/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.server.rules;

import com.consol.citrus.db.server.JdbcServerException;
import com.consol.citrus.db.server.rules.Mapping;
import com.consol.citrus.db.server.rules.Precondition;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rule<P, R, T extends Rule> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final Precondition<P> precondition;
    private final Mapping<P, R> mapping;
    private AtomicInteger maxInvocation;
    private final T self;

    public Rule() {
        this(predicate -> null);
    }

    public Rule(Mapping<P, R> mapping) {
        this(Precondition.matchAll(), mapping);
    }

    public Rule(Precondition<P> precondition, Mapping<P, R> mapping) {
        this.precondition = precondition;
        this.mapping = mapping;
        this.self = this;
    }

    public final boolean matches(P candidate) {
        boolean matching;
        boolean bl = matching = (this.maxInvocation == null || this.maxInvocation.get() != 0) && this.precondition.match(candidate);
        if (matching) {
            this.log.debug(String.format("Found matching rule for candidate '%s'", Optional.ofNullable(candidate).map(Object::toString).orElse("")));
        } else {
            this.log.trace(String.format("Rule mismatch for candidate '%s'", Optional.ofNullable(candidate).map(Object::toString).orElse("")));
        }
        return matching;
    }

    public final R applyOn(P domainObject) throws JdbcServerException {
        if (this.maxInvocation != null) {
            this.maxInvocation.decrementAndGet();
        }
        return this.mapping.map(domainObject);
    }

    public T times(int times) {
        this.maxInvocation = new AtomicInteger(times);
        return this.self;
    }

    public T anyTimes() {
        this.maxInvocation = null;
        return this.self;
    }
}

