/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.docs;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.docs.ExcelTestDocsGenerator;
import com.consol.citrus.docs.TestDocsGenerator;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.util.PropertyUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.SAXException;

public abstract class AbstractTestDocsGenerator
implements TestDocsGenerator {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String OVERVIEW_PLACEHOLDER = "+++++ OVERVIEW +++++";
    private static final String BODY_PLACEHOLDER = "+++++ BODY +++++";
    private static final String OUTPUT_DIRECTORY = "target" + File.separator + "docs";
    String srcDirectory = CitrusSettings.DEFAULT_TEST_SRC_DIRECTORY;
    private String testDocTemplate;
    String outputFile;
    private List<File> testFiles = null;

    AbstractTestDocsGenerator(String outputFile, String testDocTemplate) {
        this.outputFile = outputFile;
        this.testDocTemplate = testDocTemplate;
    }

    @Override
    public void generateDoc() {
        BufferedReader reader = null;
        FileOutputStream fos = null;
        BufferedOutputStream buffered = null;
        try {
            String line;
            Properties props = this.getTestDocProperties();
            fos = this.getFileOutputStream(this.outputFile);
            buffered = new BufferedOutputStream(fos);
            reader = new BufferedReader(new InputStreamReader(ExcelTestDocsGenerator.class.getResourceAsStream(this.testDocTemplate)));
            while ((line = reader.readLine()) != null) {
                if (line.trim().equalsIgnoreCase(OVERVIEW_PLACEHOLDER)) {
                    this.doHeader(buffered);
                    continue;
                }
                if (line.trim().equalsIgnoreCase(BODY_PLACEHOLDER)) {
                    this.doBody(buffered);
                    continue;
                }
                buffered.write((PropertyUtils.replacePropertiesInString((String)line, (Properties)props) + "\n").getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (IOException | TransformerException | SAXException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.log.error("Failed to close reader", (Throwable)e);
                }
            }
            if (buffered != null) {
                try {
                    buffered.flush();
                }
                catch (IOException e) {
                    this.log.error("Failed to close output stream", (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    this.log.error("Failed to close file", (Throwable)e);
                }
            }
        }
    }

    FileOutputStream getFileOutputStream(String fileName) throws IOException {
        File file = new File(OUTPUT_DIRECTORY);
        if (!file.exists() && !file.mkdirs()) {
            throw new CitrusRuntimeException("Unable to create folder structure for test documentation");
        }
        return new FileOutputStream(file.getAbsolutePath() + File.separator + fileName);
    }

    public abstract void doBody(OutputStream var1) throws TransformerException, IOException, SAXException;

    public abstract void doHeader(OutputStream var1) throws TransformerException, IOException, SAXException;

    protected abstract Properties getTestDocProperties();

    List<File> getTestFiles() throws IOException {
        if (this.testFiles == null) {
            this.testFiles = FileUtils.findFiles((String)Paths.get(this.srcDirectory, "resources").toString(), (Set)CitrusSettings.getXmlTestFileNamePattern());
        }
        return this.testFiles;
    }

    DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    Transformer getTransformer(String fileName, String mediaType, String method) {
        try {
            StreamSource source = new StreamSource(new ClassPathResource(fileName, this.getClass()).getInputStream());
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer t = factory.newTransformer(source);
            t.setOutputProperty("media-type", mediaType);
            t.setOutputProperty("method", method);
            return t;
        }
        catch (IOException | TransformerException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    void setSrcDirectory(String srcDirectory) {
        this.srcDirectory = srcDirectory;
    }

    public String getSrcDirectory() {
        return this.srcDirectory;
    }

    void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    String getOutputFile() {
        return this.outputFile;
    }

    static String getOutputDirectory() {
        return OUTPUT_DIRECTORY;
    }
}

