/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ftp.client;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.ftp.client.ScpEndpointConfiguration;
import com.consol.citrus.ftp.client.SftpClient;
import com.consol.citrus.ftp.message.FtpMessage;
import com.consol.citrus.ftp.model.CommandType;
import com.consol.citrus.ftp.model.DeleteCommand;
import com.consol.citrus.ftp.model.GetCommand;
import com.consol.citrus.ftp.model.ListCommand;
import com.consol.citrus.ftp.model.PutCommand;
import com.consol.citrus.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Optional;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.scp.ScpClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ScpClient
extends SftpClient {
    private static Logger log = LoggerFactory.getLogger(ScpClient.class);
    private org.apache.sshd.client.scp.ScpClient scpClient;

    public ScpClient() {
        this(new ScpEndpointConfiguration());
    }

    protected ScpClient(ScpEndpointConfiguration endpointConfiguration) {
        super(endpointConfiguration);
    }

    @Override
    public ScpEndpointConfiguration getEndpointConfiguration() {
        return (ScpEndpointConfiguration)super.getEndpointConfiguration();
    }

    @Override
    protected FtpMessage createDir(CommandType ftpCommand) {
        throw new UnsupportedOperationException("SCP client does not support create directory operation - please use sftp client");
    }

    @Override
    protected FtpMessage listFiles(ListCommand list, TestContext context) {
        throw new UnsupportedOperationException("SCP client does not support list files operation - please use sftp client");
    }

    @Override
    protected FtpMessage deleteFile(DeleteCommand delete, TestContext context) {
        throw new UnsupportedOperationException("SCP client does not support delete file operation - please use sftp client");
    }

    @Override
    protected FtpMessage storeFile(PutCommand command, TestContext context) {
        try {
            this.scpClient.upload(FileUtils.getFileResource((String)command.getFile().getPath(), (TestContext)context).getFile().getAbsolutePath(), command.getTarget().getPath(), new ScpClient.Option[0]);
        }
        catch (IOException e) {
            log.error("Failed to store file via SCP", (Throwable)e);
            return FtpMessage.error();
        }
        return FtpMessage.success();
    }

    @Override
    protected FtpMessage retrieveFile(GetCommand command, TestContext context) {
        try {
            Resource target = FileUtils.getFileResource((String)command.getTarget().getPath(), (TestContext)context);
            if (!Optional.ofNullable(target.getFile().getParentFile()).map(File::mkdirs).orElse(true).booleanValue()) {
                log.warn("Failed to create target directories in path: " + target.getFile().getAbsolutePath());
            }
            this.scpClient.download(command.getFile().getPath(), target.getFile().getAbsolutePath(), new ScpClient.Option[0]);
        }
        catch (IOException e) {
            log.error("Failed to retrieve file via SCP", (Throwable)e);
            return FtpMessage.error();
        }
        return FtpMessage.success();
    }

    @Override
    protected void connectAndLogin() {
        PrintStream out = Optional.ofNullable(this.getEndpointConfiguration().getStdout()).orElse(System.out);
        PrintStream err = Optional.ofNullable(this.getEndpointConfiguration().getStderr()).orElse(System.err);
        try (BufferedReader stdinReader = new BufferedReader(new InputStreamReader((InputStream)new NoCloseInputStream(Optional.ofNullable(this.getEndpointConfiguration().getStdin()).orElse(System.in))));){
            ClientSession session = SshClient.setupClientSession((String)this.getEndpointConfiguration().getPortOption(), (BufferedReader)stdinReader, (PrintStream)out, (PrintStream)err, (String[])new String[]{this.getEndpointConfiguration().getPortOption(), String.valueOf(this.getEndpointConfiguration().getPort()), "-o", "HostKeyAlgorithms=+ssh-dss", "-i", this.getPrivateKeyPath(), "-l", this.getEndpointConfiguration().getUser(), this.getEndpointConfiguration().getHost()});
            this.scpClient = session.createScpClient();
        }
        catch (Exception e) {
            throw new CitrusRuntimeException(String.format("Failed to login to SCP server using credentials: %s:%s:%s", this.getEndpointConfiguration().getUser(), this.getEndpointConfiguration().getPassword(), this.getEndpointConfiguration().getPrivateKeyPath()), (Throwable)e);
        }
    }

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    public void destroy() throws Exception {
    }
}

