/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ftp.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.ftp.client.FtpClient;
import com.consol.citrus.ftp.client.FtpClientBuilder;
import com.consol.citrus.ftp.config.annotation.FtpClientConfig;
import com.consol.citrus.message.MessageCorrelator;
import org.springframework.util.StringUtils;

public class FtpClientConfigParser
extends AbstractAnnotationConfigParser<FtpClientConfig, FtpClient> {
    public FtpClientConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public FtpClient parse(FtpClientConfig annotation) {
        FtpClientBuilder builder = new FtpClientBuilder();
        if (StringUtils.hasText((String)annotation.host())) {
            builder.host(annotation.host());
        }
        builder.port(annotation.port());
        builder.autoReadFiles(annotation.autoReadFiles());
        if (StringUtils.hasText((String)annotation.username())) {
            builder.username(annotation.username());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)this.getReferenceResolver().resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.errorHandlingStrategy(annotation.errorStrategy());
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (FtpClient)builder.initialize().build();
    }
}

