/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ftp.server;

import com.consol.citrus.endpoint.AbstractEndpointBuilder;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.ftp.server.FtpServer;
import org.apache.ftpserver.ftplet.UserManager;
import org.springframework.core.io.Resource;

public class FtpServerBuilder
extends AbstractEndpointBuilder<FtpServer> {
    private FtpServer endpoint = new FtpServer();

    protected FtpServer getEndpoint() {
        return this.endpoint;
    }

    public FtpServerBuilder port(int port) {
        this.endpoint.getEndpointConfiguration().setPort(port);
        return this;
    }

    public FtpServerBuilder autoStart(boolean autoStart) {
        this.endpoint.setAutoStart(autoStart);
        return this;
    }

    public FtpServerBuilder autoConnect(boolean autoConnect) {
        this.endpoint.getEndpointConfiguration().setAutoConnect(autoConnect);
        return this;
    }

    public FtpServerBuilder autoLogin(boolean autoLogin) {
        this.endpoint.getEndpointConfiguration().setAutoLogin(autoLogin);
        return this;
    }

    public FtpServerBuilder autoHandleCommands(String autoHandleCommands) {
        this.endpoint.getEndpointConfiguration().setAutoHandleCommands(autoHandleCommands);
        return this;
    }

    public FtpServerBuilder server(org.apache.ftpserver.FtpServer server) {
        this.endpoint.setFtpServer(server);
        return this;
    }

    public FtpServerBuilder userManager(UserManager userManager) {
        this.endpoint.setUserManager(userManager);
        return this;
    }

    public FtpServerBuilder userManagerProperties(Resource userManagerProperties) {
        this.endpoint.setUserManagerProperties(userManagerProperties);
        return this;
    }

    public FtpServerBuilder endpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpoint.setEndpointAdapter(endpointAdapter);
        return this;
    }

    public FtpServerBuilder debugLogging(boolean enabled) {
        this.endpoint.setDebugLogging(enabled);
        return this;
    }

    public FtpServerBuilder timeout(long timeout) {
        this.endpoint.setDefaultTimeout(timeout);
        return this;
    }
}

