/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ftp.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.ftp.client.SftpClient;
import com.consol.citrus.ftp.client.SftpClientBuilder;
import com.consol.citrus.ftp.config.annotation.SftpClientConfig;
import com.consol.citrus.message.MessageCorrelator;
import java.util.Map;
import org.springframework.util.StringUtils;

public class SftpClientConfigParser
extends AbstractAnnotationConfigParser<SftpClientConfig, SftpClient> {
    public SftpClientConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public SftpClient parse(SftpClientConfig annotation) {
        SftpClientBuilder builder = new SftpClientBuilder();
        if (StringUtils.hasText((String)annotation.host())) {
            builder.host(annotation.host());
        }
        builder.port(annotation.port());
        builder.autoReadFiles(annotation.autoReadFiles());
        builder.localPassiveMode(annotation.localPassiveMode());
        if (StringUtils.hasText((String)annotation.username())) {
            builder.username(annotation.username());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.privateKeyPath())) {
            builder.privateKeyPath(annotation.privateKeyPath());
        }
        if (StringUtils.hasText((String)annotation.privateKeyPassword())) {
            builder.privateKeyPassword(annotation.privateKeyPassword());
        }
        builder.strictHostChecking(annotation.strictHostChecking());
        if (StringUtils.hasText((String)annotation.knownHosts())) {
            builder.knownHosts(annotation.knownHosts());
        }
        if (StringUtils.hasText((String)annotation.preferredAuthentications())) {
            builder.preferredAuthentications(annotation.preferredAuthentications());
        }
        if (StringUtils.hasText((String)annotation.sessionConfigs())) {
            builder.sessionConfigs((Map)this.getReferenceResolver().resolve(annotation.sessionConfigs(), Map.class));
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)this.getReferenceResolver().resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.errorHandlingStrategy(annotation.errorStrategy());
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (SftpClient)builder.initialize().build();
    }
}

