/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ftp.server;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.ftp.client.FtpEndpointConfiguration;
import com.consol.citrus.ftp.server.FtpServerFtpLet;
import com.consol.citrus.server.AbstractServer;
import java.io.IOException;
import java.util.HashMap;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.filesystem.nativefs.NativeFileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class FtpServer
extends AbstractServer
implements InitializingBean {
    private FtpServerFactory serverFactory;
    private ListenerFactory listenerFactory;
    private UserManager userManager;
    private org.apache.ftpserver.FtpServer ftpServer;
    private final FtpEndpointConfiguration endpointConfiguration;
    private Resource userManagerProperties;
    private static Object serverLock = new Object();

    public FtpServer() {
        this(new FtpEndpointConfiguration());
    }

    public FtpServer(FtpEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        Object object = serverLock;
        synchronized (object) {
            if (this.ftpServer == null) {
                this.listenerFactory.setPort(this.endpointConfiguration.getPort().intValue());
                this.serverFactory.addListener("default", this.listenerFactory.createListener());
                if (this.userManager != null) {
                    this.serverFactory.setUserManager(this.userManager);
                } else if (this.userManagerProperties != null) {
                    PropertiesUserManagerFactory userManagerFactory = new PropertiesUserManagerFactory();
                    try {
                        userManagerFactory.setFile(this.userManagerProperties.getFile());
                    }
                    catch (IOException e) {
                        throw new CitrusRuntimeException("Failed to load user manager properties", (Throwable)e);
                    }
                    this.serverFactory.setUserManager(userManagerFactory.createUserManager());
                }
                NativeFileSystemFactory fileSystemFactory = new NativeFileSystemFactory();
                fileSystemFactory.setCreateHome(true);
                this.serverFactory.setFileSystem((FileSystemFactory)fileSystemFactory);
                HashMap<String, FtpServerFtpLet> ftpLets = new HashMap<String, FtpServerFtpLet>();
                ftpLets.put("citrusFtpLet", new FtpServerFtpLet(this.getEndpointConfiguration(), this.getEndpointAdapter()));
                this.serverFactory.setFtplets(ftpLets);
                this.ftpServer = this.serverFactory.createServer();
            }
            try {
                this.ftpServer.start();
            }
            catch (FtpException e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        if (this.ftpServer != null) {
            try {
                Object object = serverLock;
                synchronized (object) {
                    this.ftpServer.stop();
                }
            }
            catch (Exception e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    public FtpEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ftpServer == null) {
            if (this.serverFactory == null) {
                this.serverFactory = new FtpServerFactory();
            }
            if (this.listenerFactory == null) {
                this.listenerFactory = new ListenerFactory();
            }
        }
        super.afterPropertiesSet();
    }

    public void setFtpServer(org.apache.ftpserver.FtpServer ftpServer) {
        this.ftpServer = ftpServer;
    }

    public org.apache.ftpserver.FtpServer getFtpServer() {
        return this.ftpServer;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManagerProperties(Resource userManagerProperties) {
        this.userManagerProperties = userManagerProperties;
    }

    public Resource getUserManagerProperties() {
        return this.userManagerProperties;
    }

    public void setListenerFactory(ListenerFactory listenerFactory) {
        this.listenerFactory = listenerFactory;
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }
}

