/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ftp.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.ftp.client.ScpClient;
import com.consol.citrus.ftp.client.ScpClientBuilder;
import com.consol.citrus.ftp.config.annotation.ScpClientConfig;
import com.consol.citrus.message.MessageCorrelator;
import com.consol.citrus.spi.ReferenceResolver;
import org.springframework.util.StringUtils;

public class ScpClientConfigParser
extends AbstractAnnotationConfigParser<ScpClientConfig, ScpClient> {
    public ScpClientConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public ScpClient parse(ScpClientConfig annotation) {
        ScpClientBuilder builder = new ScpClientBuilder();
        if (StringUtils.hasText((String)annotation.host())) {
            builder.host(annotation.host());
        }
        builder.port(annotation.port());
        builder.portOption(annotation.portOption());
        if (StringUtils.hasText((String)annotation.username())) {
            builder.username(annotation.username());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.privateKeyPath())) {
            builder.privateKeyPath(annotation.privateKeyPath());
        }
        if (StringUtils.hasText((String)annotation.privateKeyPassword())) {
            builder.privateKeyPassword(annotation.privateKeyPassword());
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)this.getReferenceResolver().resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.errorHandlingStrategy(annotation.errorStrategy());
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (ScpClient)builder.initialize().build();
    }
}

