/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ftp.server;

import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.ftp.client.FtpEndpointConfiguration;
import com.consol.citrus.ftp.message.FtpMessage;
import com.consol.citrus.ftp.model.Command;
import com.consol.citrus.ftp.model.CommandResultType;
import com.consol.citrus.message.Message;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.transform.Result;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.FtpletContext;
import org.apache.ftpserver.ftplet.FtpletResult;
import org.apache.ftpserver.ftplet.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.StringResult;

public class FtpServerFtpLet
implements Ftplet {
    private static Logger log = LoggerFactory.getLogger(FtpServerFtpLet.class);
    private final FtpEndpointConfiguration endpointConfiguration;
    private final EndpointAdapter endpointAdapter;

    public FtpServerFtpLet(FtpEndpointConfiguration endpointConfiguration, EndpointAdapter endpointAdapter) {
        this.endpointConfiguration = endpointConfiguration;
        this.endpointAdapter = endpointAdapter;
    }

    public FtpMessage handleMessage(FtpMessage request) {
        if (request.getPayload() instanceof Command) {
            StringResult result = new StringResult();
            this.endpointConfiguration.getMarshaller().marshal(request.getPayload(Command.class), (Result)result);
            request.setPayload(result.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received request on ftp server: '%s':%n%s", request.getSignal(), request.getPayload(String.class)));
        }
        return Optional.ofNullable(this.endpointAdapter.handleMessage((Message)request)).map(response -> {
            if (response instanceof FtpMessage) {
                return (FtpMessage)((Object)response);
            }
            return new FtpMessage((Message)response);
        }).orElse(FtpMessage.success());
    }

    public void init(FtpletContext ftpletContext) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Total FTP logins: %s", ftpletContext.getFtpStatistics().getTotalLoginNumber()));
        }
    }

    public void destroy() {
        log.info("FTP server shutting down ...");
    }

    public FtpletResult beforeCommand(FtpSession session, FtpRequest request) {
        String command = request.getCommand().toUpperCase();
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received FTP command: '%s'", command));
        }
        if (this.endpointConfiguration.isAutoLogin() && (command.equals(FTPCmd.USER.getCommand()) || command.equals(FTPCmd.PASS.getCommand()))) {
            return FtpletResult.DEFAULT;
        }
        if (Stream.of(StringUtils.commaDelimitedListToStringArray((String)this.endpointConfiguration.getAutoHandleCommands())).anyMatch(cmd -> cmd.trim().equals(command))) {
            return FtpletResult.DEFAULT;
        }
        FtpMessage response = this.handleMessage(FtpMessage.command(FTPCmd.valueOf((String)command)).arguments(request.getArgument()));
        if (response.hasReplyCode()) {
            this.writeFtpReply(session, response);
            return FtpletResult.SKIP;
        }
        return FtpletResult.DEFAULT;
    }

    public FtpletResult afterCommand(FtpSession session, FtpRequest request, FtpReply reply) {
        return FtpletResult.DEFAULT;
    }

    public FtpletResult onConnect(FtpSession session) {
        FtpMessage response;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received new FTP connection: '%s'", session.getSessionId()));
        }
        if (!this.endpointConfiguration.isAutoConnect() && (response = this.handleMessage(FtpMessage.connect(session.getSessionId().toString()))).hasReplyCode()) {
            this.writeFtpReply(session, response);
            return FtpletResult.SKIP;
        }
        return FtpletResult.DEFAULT;
    }

    public FtpletResult onDisconnect(FtpSession session) {
        FtpMessage response;
        if (!this.endpointConfiguration.isAutoConnect() && (response = this.handleMessage(FtpMessage.command(FTPCmd.QUIT).arguments(Optional.ofNullable(session.getUser()).map(User::getName).orElse("unknown") + ":" + Optional.ofNullable(session.getUser()).map(User::getPassword).orElse("n/a")))).hasReplyCode()) {
            this.writeFtpReply(session, response);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Closing FTP connection: '%s'", session.getSessionId()));
        }
        return FtpletResult.DISCONNECT;
    }

    private void writeFtpReply(FtpSession session, FtpMessage response) {
        try {
            CommandResultType commandResult = response.getPayload(CommandResultType.class);
            DefaultFtpReply reply = new DefaultFtpReply(Integer.valueOf(commandResult.getReplyCode()).intValue(), commandResult.getReplyString());
            session.write((FtpReply)reply);
        }
        catch (FtpException e) {
            throw new CitrusRuntimeException("Failed to write ftp reply", (Throwable)e);
        }
    }
}

