/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ftp.client;

import com.consol.citrus.common.InitializingPhase;
import com.consol.citrus.common.ShutdownPhase;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.endpoint.PollableEndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.MessageTimeoutException;
import com.consol.citrus.ftp.client.FtpEndpointConfiguration;
import com.consol.citrus.ftp.message.FtpMessage;
import com.consol.citrus.ftp.model.CommandType;
import com.consol.citrus.ftp.model.DeleteCommand;
import com.consol.citrus.ftp.model.GetCommand;
import com.consol.citrus.ftp.model.ListCommand;
import com.consol.citrus.ftp.model.PutCommand;
import com.consol.citrus.message.ErrorHandlingStrategy;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.correlation.CorrelationManager;
import com.consol.citrus.message.correlation.PollingCorrelationManager;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.messaging.ReplyConsumer;
import com.consol.citrus.messaging.SelectiveConsumer;
import com.consol.citrus.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.ftpserver.ftplet.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class FtpClient
extends AbstractEndpoint
implements Producer,
ReplyConsumer,
InitializingPhase,
ShutdownPhase {
    private static final Logger LOG = LoggerFactory.getLogger(FtpClient.class);
    private FTPClient ftpClient;
    private CorrelationManager<Message> correlationManager;

    public FtpClient() {
        this(new FtpEndpointConfiguration());
    }

    protected FtpClient(FtpEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply message did not arrive yet");
    }

    public FtpEndpointConfiguration getEndpointConfiguration() {
        return (FtpEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void send(Message message, TestContext context) {
        FtpMessage ftpMessage = message instanceof FtpMessage ? (FtpMessage)message : new FtpMessage(message);
        String correlationKeyName = this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.getEndpointConfiguration().getCorrelator().getCorrelationKey((Message)ftpMessage);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Sending FTP message to: ftp://'%s:%s'", this.getEndpointConfiguration().getHost(), this.getEndpointConfiguration().getPort()));
            LOG.debug("Message to send:\n" + ftpMessage.getPayload(String.class));
        }
        try {
            this.connectAndLogin();
            CommandType ftpCommand = ftpMessage.getPayload(CommandType.class);
            FtpMessage response = ftpCommand instanceof GetCommand ? this.retrieveFile((GetCommand)ftpCommand, context) : (ftpCommand instanceof PutCommand ? this.storeFile((PutCommand)ftpCommand, context) : (ftpCommand instanceof ListCommand ? this.listFiles((ListCommand)ftpCommand, context) : (ftpCommand instanceof DeleteCommand ? this.deleteFile((DeleteCommand)ftpCommand, context) : this.executeCommand(ftpCommand, context))));
            if (this.getEndpointConfiguration().getErrorHandlingStrategy().equals((Object)ErrorHandlingStrategy.THROWS_EXCEPTION) && !this.isPositive(response.getReplyCode())) {
                throw new CitrusRuntimeException(String.format("Failed to send FTP command - reply is: %s:%s", response.getReplyCode(), response.getReplyString()));
            }
            LOG.info(String.format("FTP message was sent to: '%s:%s'", this.getEndpointConfiguration().getHost(), this.getEndpointConfiguration().getPort()));
            this.correlationManager.store(correlationKey, (Object)response);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to execute ftp command", (Throwable)e);
        }
    }

    protected FtpMessage executeCommand(CommandType ftpCommand, TestContext context) {
        try {
            int reply = this.ftpClient.sendCommand(ftpCommand.getSignal(), ftpCommand.getArguments());
            return FtpMessage.result(reply, this.ftpClient.getReplyString(), this.isPositive(reply));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to execute ftp command", (Throwable)e);
        }
    }

    private boolean isPositive(int reply) {
        return FTPReply.isPositiveCompletion((int)reply) || FTPReply.isPositivePreliminary((int)reply);
    }

    protected FtpMessage listFiles(ListCommand list, TestContext context) {
        String remoteFilePath = Optional.ofNullable(list.getTarget()).map(ListCommand.Target::getPath).map(arg_0 -> ((TestContext)context).replaceDynamicContentInString(arg_0)).orElse("");
        try {
            ArrayList<String> fileNames = new ArrayList<String>();
            FTPFile[] ftpFiles = StringUtils.hasText((String)remoteFilePath) ? this.ftpClient.listFiles(remoteFilePath) : this.ftpClient.listFiles(remoteFilePath);
            for (FTPFile ftpFile : ftpFiles) {
                fileNames.add(ftpFile.getName());
            }
            return FtpMessage.result(this.ftpClient.getReplyCode(), this.ftpClient.getReplyString(), fileNames);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to list files in path '%s'", remoteFilePath), (Throwable)e);
        }
    }

    protected FtpMessage deleteFile(DeleteCommand delete, TestContext context) {
        String remoteFilePath = context.replaceDynamicContentInString(delete.getTarget().getPath());
        try {
            if (!StringUtils.hasText((String)remoteFilePath)) {
                return null;
            }
            boolean success = true;
            if (this.isDirectory(remoteFilePath)) {
                if (!this.ftpClient.changeWorkingDirectory(remoteFilePath)) {
                    throw new CitrusRuntimeException("Failed to change working directory to " + remoteFilePath + ". FTP reply code: " + this.ftpClient.getReplyString());
                }
                if (delete.isRecursive()) {
                    FTPFile[] ftpFiles;
                    for (FTPFile ftpFile : ftpFiles = this.ftpClient.listFiles()) {
                        DeleteCommand recursiveDelete = new DeleteCommand();
                        DeleteCommand.Target target = new DeleteCommand.Target();
                        target.setPath(remoteFilePath + "/" + ftpFile.getName());
                        recursiveDelete.setTarget(target);
                        recursiveDelete.setIncludeCurrent(true);
                        this.deleteFile(recursiveDelete, context);
                    }
                }
                if (delete.isIncludeCurrent()) {
                    this.ftpClient.changeWorkingDirectory("/");
                    success = this.ftpClient.removeDirectory(remoteFilePath);
                }
            } else {
                success = this.ftpClient.deleteFile(remoteFilePath);
            }
            if (!success) {
                throw new CitrusRuntimeException("Failed to delete path " + remoteFilePath + ". FTP reply code: " + this.ftpClient.getReplyString());
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to delete file from FTP server", (Throwable)e);
        }
        if (this.ftpClient.getReplyCode() != 250) {
            return FtpMessage.deleteResult(250, String.format("%s No files to delete.", 250), true);
        }
        return FtpMessage.deleteResult(this.ftpClient.getReplyCode(), this.ftpClient.getReplyString(), this.isPositive(this.ftpClient.getReplyCode()));
    }

    protected boolean isDirectory(String remoteFilePath) throws IOException {
        if (!this.ftpClient.changeWorkingDirectory(remoteFilePath)) {
            switch (this.ftpClient.listFiles(remoteFilePath).length) {
                case 0: {
                    throw new CitrusRuntimeException("Remote file path does not exist or is not accessible: " + remoteFilePath);
                }
                case 1: {
                    return false;
                }
            }
            throw new CitrusRuntimeException("Unexpected file type result for file path: " + remoteFilePath);
        }
        return true;
    }

    protected FtpMessage storeFile(PutCommand command, TestContext context) {
        try {
            String localFilePath = context.replaceDynamicContentInString(command.getFile().getPath());
            String remoteFilePath = FtpClient.addFileNameToTargetPath(localFilePath, context.replaceDynamicContentInString(command.getTarget().getPath()));
            String dataType = context.replaceDynamicContentInString(Optional.ofNullable(command.getFile().getType()).orElse(DataType.BINARY.name()));
            try (InputStream localFileInputStream = this.getLocalFileInputStream(command.getFile().getPath(), dataType, context);){
                this.ftpClient.setFileType(this.getFileType(dataType));
                if (!this.ftpClient.storeFile(remoteFilePath, localFileInputStream)) {
                    throw new IOException("Failed to put file to FTP server. Remote path: " + remoteFilePath + ". Local file path: " + localFilePath + ". FTP reply: " + this.ftpClient.getReplyString());
                }
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to put file to FTP server", (Throwable)e);
        }
        return FtpMessage.putResult(this.ftpClient.getReplyCode(), this.ftpClient.getReplyString(), this.isPositive(this.ftpClient.getReplyCode()));
    }

    protected InputStream getLocalFileInputStream(String path, String dataType, TestContext context) throws IOException {
        if (dataType.equals(DataType.ASCII.name())) {
            String content = context.replaceDynamicContentInString(FileUtils.readToString((Resource)FileUtils.getFileResource((String)path)));
            return new ByteArrayInputStream(content.getBytes(FileUtils.getDefaultCharset()));
        }
        return FileUtils.getFileResource((String)path).getInputStream();
    }

    protected FtpMessage retrieveFile(GetCommand command, TestContext context) {
        try {
            String remoteFilePath = context.replaceDynamicContentInString(command.getFile().getPath());
            String localFilePath = FtpClient.addFileNameToTargetPath(remoteFilePath, context.replaceDynamicContentInString(command.getTarget().getPath()));
            if (Paths.get(localFilePath, new String[0]).getParent() != null) {
                Files.createDirectories(Paths.get(localFilePath, new String[0]).getParent(), new FileAttribute[0]);
            }
            String dataType = context.replaceDynamicContentInString(Optional.ofNullable(command.getFile().getType()).orElse(DataType.BINARY.name()));
            try (FileOutputStream localFileOutputStream = new FileOutputStream(localFilePath);){
                this.ftpClient.setFileType(this.getFileType(dataType));
                if (!this.ftpClient.retrieveFile(remoteFilePath, (OutputStream)localFileOutputStream)) {
                    throw new CitrusRuntimeException("Failed to get file from FTP server. Remote path: " + remoteFilePath + ". Local file path: " + localFilePath + ". FTP reply: " + this.ftpClient.getReplyString());
                }
            }
            if (this.getEndpointConfiguration().isAutoReadFiles()) {
                String fileContent = command.getFile().getType().equals(DataType.BINARY.name()) ? Base64.encodeBase64String((byte[])FileCopyUtils.copyToByteArray((InputStream)FileUtils.getFileResource((String)localFilePath).getInputStream())) : FileUtils.readToString((Resource)FileUtils.getFileResource((String)localFilePath));
                return FtpMessage.result(this.ftpClient.getReplyCode(), this.ftpClient.getReplyString(), localFilePath, fileContent);
            }
            return FtpMessage.result(this.ftpClient.getReplyCode(), this.ftpClient.getReplyString(), localFilePath, null);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to get file from FTP server", (Throwable)e);
        }
    }

    private int getFileType(String typeInfo) {
        switch (typeInfo) {
            case "ASCII": {
                return 0;
            }
            case "BINARY": {
                return 2;
            }
            case "EBCDIC": {
                return 1;
            }
            case "LOCAL": {
                return 3;
            }
        }
        return 2;
    }

    protected static String addFileNameToTargetPath(String sourcePath, String targetPath) {
        if (targetPath.endsWith("/")) {
            String filename = Paths.get(sourcePath, new String[0]).getFileName().toString();
            return targetPath + filename;
        }
        return targetPath;
    }

    protected void connectAndLogin() throws IOException {
        if (!this.ftpClient.isConnected()) {
            int reply;
            this.ftpClient.connect(this.getEndpointConfiguration().getHost(), this.getEndpointConfiguration().getPort());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connected to FTP server: " + this.ftpClient.getReplyString());
            }
            if (!FTPReply.isPositiveCompletion((int)(reply = this.ftpClient.getReplyCode()))) {
                throw new CitrusRuntimeException("FTP server refused connection.");
            }
            LOG.info("Opened connection to FTP server");
            if (this.getEndpointConfiguration().getUser() != null) {
                boolean login;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Login as user: '%s'", this.getEndpointConfiguration().getUser()));
                }
                if (!(login = this.ftpClient.login(this.getEndpointConfiguration().getUser(), this.getEndpointConfiguration().getPassword()))) {
                    throw new CitrusRuntimeException(String.format("Failed to login to FTP server using credentials: %s:%s", this.getEndpointConfiguration().getUser(), this.getEndpointConfiguration().getPassword()));
                }
            }
            if (this.getEndpointConfiguration().isLocalPassiveMode()) {
                this.ftpClient.enterLocalPassiveMode();
            }
        }
    }

    public Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    public Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.getEndpointConfiguration().getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message = (Message)this.correlationManager.find(selector, timeout);
        if (message == null) {
            throw new MessageTimeoutException(timeout, this.getEndpointConfiguration().getHost() + ":" + this.getEndpointConfiguration().getPort());
        }
        return message;
    }

    public void initialize() {
        if (this.ftpClient == null) {
            this.ftpClient = new FTPClient();
        }
        FTPClientConfig config = new FTPClientConfig();
        config.setServerTimeZoneId(TimeZone.getDefault().getID());
        this.ftpClient.configure(config);
        this.ftpClient.addProtocolCommandListener(new ProtocolCommandListener(){

            public void protocolCommandSent(ProtocolCommandEvent event) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send FTP command: " + event.getCommand());
                }
            }

            public void protocolReplyReceived(ProtocolCommandEvent event) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received FTP command reply: " + event.getReplyCode());
                }
            }
        });
    }

    public void destroy() {
        block4: {
            try {
                if (!this.ftpClient.isConnected()) break block4;
                this.ftpClient.logout();
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    LOG.warn("Failed to disconnect from FTP server", (Throwable)e);
                }
                LOG.info("Closed connection to FTP server");
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to logout from FTP server", (Throwable)e);
            }
        }
    }

    public Producer createProducer() {
        return this;
    }

    public SelectiveConsumer createConsumer() {
        return this;
    }

    public void setFtpClient(FTPClient ftpClient) {
        this.ftpClient = ftpClient;
    }

    public FTPClient getFtpClient() {
        return this.ftpClient;
    }

    public void setCorrelationManager(CorrelationManager<Message> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

