/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ftp.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.ftp.client.SftpClient;
import com.consol.citrus.ftp.client.SftpClientBuilder;
import com.consol.citrus.ftp.config.annotation.SftpClientConfig;
import com.consol.citrus.message.MessageCorrelator;
import com.consol.citrus.spi.ReferenceResolver;
import java.util.Map;
import org.springframework.util.StringUtils;

public class SftpClientConfigParser
implements AnnotationConfigParser<SftpClientConfig, SftpClient> {
    public SftpClient parse(SftpClientConfig annotation, ReferenceResolver referenceResolver) {
        SftpClientBuilder builder = new SftpClientBuilder();
        if (StringUtils.hasText((String)annotation.host())) {
            builder.host(annotation.host());
        }
        builder.port(annotation.port());
        builder.autoReadFiles(annotation.autoReadFiles());
        builder.localPassiveMode(annotation.localPassiveMode());
        if (StringUtils.hasText((String)annotation.username())) {
            builder.username(annotation.username());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.privateKeyPath())) {
            builder.privateKeyPath(annotation.privateKeyPath());
        }
        if (StringUtils.hasText((String)annotation.privateKeyPassword())) {
            builder.privateKeyPassword(annotation.privateKeyPassword());
        }
        builder.strictHostChecking(annotation.strictHostChecking());
        if (StringUtils.hasText((String)annotation.knownHosts())) {
            builder.knownHosts(annotation.knownHosts());
        }
        if (StringUtils.hasText((String)annotation.preferredAuthentications())) {
            builder.preferredAuthentications(annotation.preferredAuthentications());
        }
        if (StringUtils.hasText((String)annotation.sessionConfigs())) {
            builder.sessionConfigs((Map)referenceResolver.resolve(annotation.sessionConfigs(), Map.class));
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)referenceResolver.resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.errorHandlingStrategy(annotation.errorStrategy());
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (SftpClient)builder.initialize().build();
    }
}

