/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ftp.server;

import com.consol.citrus.endpoint.AbstractPollableEndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.ftp.client.SftpEndpointConfiguration;
import com.consol.citrus.ftp.message.FtpMessage;
import com.consol.citrus.ftp.model.Command;
import com.consol.citrus.ftp.model.CommandResult;
import com.consol.citrus.message.Message;
import com.consol.citrus.ssh.server.SshServer;
import com.consol.citrus.xml.StringResult;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.xml.transform.Result;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.FileHandle;
import org.apache.sshd.sftp.server.SftpEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpServer
extends SshServer
implements ScpTransferEventListener,
SftpEventListener {
    private static final Logger logger = LoggerFactory.getLogger(SftpServer.class);
    private final SftpEndpointConfiguration endpointConfiguration;

    public SftpServer() {
        this(new SftpEndpointConfiguration());
    }

    public SftpServer(SftpEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    public FtpMessage handleMessage(FtpMessage request) {
        if (request.getPayload() instanceof Command) {
            StringResult result = new StringResult();
            this.endpointConfiguration.getMarshaller().marshal(request.getPayload(Command.class), (Result)result);
            request.setPayload(result.toString());
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Received request on ftp server: '%s':%n%s", request.getSignal(), request.getPayload(String.class)));
        }
        return Optional.ofNullable(this.getEndpointAdapter().handleMessage((Message)request)).map(response -> {
            if (response instanceof FtpMessage) {
                return (FtpMessage)((Object)response);
            }
            return new FtpMessage((Message)response);
        }).orElseGet(FtpMessage::success);
    }

    public void startFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, long length, Set<PosixFilePermission> perms) {
        this.startFolderEvent(session, op, file, perms);
    }

    public void startFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path file, Set<PosixFilePermission> perms) {
        FtpMessage response;
        if (op.equals((Object)ScpTransferEventListener.FileOperation.SEND)) {
            FtpMessage response2 = this.handleMessage(FtpMessage.get(file.toString()));
            if (response2.hasException()) {
                throw new CitrusRuntimeException(response2.getPayload(CommandResult.class).getException());
            }
        } else if (op.equals((Object)ScpTransferEventListener.FileOperation.RECEIVE) && (response = this.handleMessage(FtpMessage.put(file.toString()))).hasException()) {
            throw new CitrusRuntimeException(response.getPayload(CommandResult.class).getException());
        }
    }

    public void initialized(ServerSession session, int version) {
        FtpMessage response;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Received new SFTP connection: '%s'", Arrays.toString(session.getSessionId())));
        }
        if (!this.endpointConfiguration.isAutoConnect() && (response = this.handleMessage(FtpMessage.connect(Arrays.toString(session.getSessionId())))).hasException()) {
            throw new CitrusRuntimeException(response.getPayload(CommandResult.class).getException());
        }
    }

    public void reading(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) {
        FtpMessage response = this.handleMessage(FtpMessage.get(localHandle.getFile().toString(), BufferUtils.toHex((char)'\u0000', (byte[])remoteHandle.getBytes(StandardCharsets.UTF_8)), DataType.ASCII));
        if (response.hasException()) {
            throw new CitrusRuntimeException(response.getPayload(CommandResult.class).getException());
        }
    }

    public void writing(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) {
        FtpMessage response = this.handleMessage(FtpMessage.put(BufferUtils.toHex((char)'\u0000', (byte[])remoteHandle.getBytes(StandardCharsets.UTF_8)), localHandle.getFile().toString(), DataType.ASCII));
        if (response.hasException()) {
            throw new CitrusRuntimeException(response.getPayload(CommandResult.class).getException());
        }
    }

    public void destroying(ServerSession session) {
        FtpMessage response;
        if (!this.endpointConfiguration.isAutoConnect() && (response = this.handleMessage(FtpMessage.command(FTPCmd.QUIT).arguments(Optional.ofNullable(session.getUsername()).orElse("unknown")))).hasException()) {
            throw new CitrusRuntimeException(response.getPayload(CommandResult.class).getException());
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Closing FTP connection: '%s'", new Object[]{session.getSessionId()}));
        }
    }

    public AbstractPollableEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    protected ScpTransferEventListener getScpTransferEventListener() {
        return this;
    }

    protected SftpEventListener getSftpEventListener() {
        return this;
    }

    public void setPort(int port) {
        super.setPort(port);
        this.endpointConfiguration.setPort(port);
    }

    public void setUser(String user) {
        super.setUser(user);
        this.endpointConfiguration.setUser(user);
    }

    public void setPassword(String password) {
        super.setPassword(password);
        this.endpointConfiguration.setPassword(password);
    }
}

