/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.config.xml.AbstractTestActionFactoryBean;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.script.GroovyAction;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GroovyActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String filePath;
        String scriptTemplatePath;
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(GroovyActionFactoryBean.class);
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)beanDefinition);
        String useScriptTemplate = element.getAttribute("use-script-template");
        if (StringUtils.hasText((String)useScriptTemplate)) {
            beanDefinition.addPropertyValue("useScriptTemplate", (Object)Boolean.valueOf(useScriptTemplate));
        }
        if (StringUtils.hasText((String)(scriptTemplatePath = element.getAttribute("script-template")))) {
            beanDefinition.addPropertyValue("scriptTemplatePath", (Object)scriptTemplatePath);
        }
        if (DomUtils.getTextValue((Element)element).length() > 0) {
            beanDefinition.addPropertyValue("script", (Object)DomUtils.getTextValue((Element)element));
        }
        if (StringUtils.hasText((String)(filePath = element.getAttribute("resource")))) {
            beanDefinition.addPropertyValue("scriptResourcePath", (Object)filePath);
        }
        return beanDefinition.getBeanDefinition();
    }

    public static class GroovyActionFactoryBean
    extends AbstractTestActionFactoryBean<GroovyAction, GroovyAction.Builder> {
        private final GroovyAction.Builder builder = new GroovyAction.Builder();

        public void setScript(String script) {
            this.builder.script(script);
        }

        public void setScriptResourcePath(String fileResource) {
            this.builder.scriptResourcePath(fileResource);
        }

        public void setScriptTemplate(String scriptTemplate) {
            this.builder.template(scriptTemplate);
        }

        public void setScriptTemplatePath(String scriptTemplate) {
            this.builder.template(scriptTemplate);
        }

        public void setUseScriptTemplate(boolean useScriptTemplate) {
            this.builder.useScriptTemplate(useScriptTemplate);
        }

        public GroovyAction getObject() throws Exception {
            return this.builder.build();
        }

        public Class<?> getObjectType() {
            return GroovyAction.class;
        }

        public GroovyAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

