/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message.builder.script;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.ScriptPayloadBuilder;
import com.consol.citrus.message.builder.script.GroovyFileResourcePayloadBuilder;
import com.consol.citrus.validation.script.TemplateBasedScriptBuilder;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import org.codehaus.groovy.control.CompilationFailedException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class GroovyScriptPayloadBuilder
implements ScriptPayloadBuilder {
    private final Resource scriptTemplateResource = new ClassPathResource("com/consol/citrus/script/markup-builder-template.groovy");
    private String script;
    private GroovyFileResourcePayloadBuilder delegate;

    public GroovyScriptPayloadBuilder() {
    }

    public GroovyScriptPayloadBuilder(String script) {
        this.script = script;
    }

    public GroovyScriptPayloadBuilder(Resource file) {
        this.delegate = new GroovyFileResourcePayloadBuilder(file);
    }

    public Object buildPayload(TestContext context) {
        if (this.delegate != null) {
            return this.delegate.buildPayload(context);
        }
        return this.buildMarkupBuilderScript(context.replaceDynamicContentInString(this.script));
    }

    protected String buildMarkupBuilderScript(String scriptData) {
        try {
            ClassLoader parent = GroovyScriptPayloadBuilder.class.getClassLoader();
            GroovyClassLoader loader = new GroovyClassLoader(parent);
            Class groovyClass = loader.parseClass(TemplateBasedScriptBuilder.fromTemplateResource((Resource)this.scriptTemplateResource).withCode(scriptData).build());
            if (groovyClass == null) {
                throw new CitrusRuntimeException("Could not load groovy script!");
            }
            GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
            return (String)groovyObject.invokeMethod("run", (Object)new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | CompilationFailedException e) {
            throw new CitrusRuntimeException(e);
        }
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setFile(Resource file) {
        this.delegate = new GroovyFileResourcePayloadBuilder(file);
    }
}

