/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.groovy.dsl.actions;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.groovy.dsl.GroovyShellUtils;
import com.consol.citrus.groovy.dsl.actions.ActionsConfiguration;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class ActionsScript {
    private final String script;
    private final Citrus citrus;
    private final TestContext context;

    public ActionsScript(String script, Citrus citrus, TestContext context) {
        this.script = script;
        this.citrus = citrus;
        this.context = context;
    }

    public void execute(TestActionRunner runner) {
        ImportCustomizer ic = new ImportCustomizer();
        GroovyShellUtils.run(ic, new ActionsConfiguration(runner, this.context), this.normalize(this.script), this.citrus, this.context);
    }

    private String normalize(String script) {
        String normalized = GroovyShellUtils.removeComments(script);
        if (!ActionsScript.isActionScript(normalized)) {
            return String.format("$(%s)", normalized);
        }
        return normalized;
    }

    public static boolean isActionScript(String script) {
        return script.startsWith("$actions {") || script.startsWith("$actions{") || script.startsWith("$finally {") || script.startsWith("$finally{") || script.startsWith("$(");
    }
}

