/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.groovy;

import com.consol.citrus.common.DefaultTestLoader;
import com.consol.citrus.common.TestSourceAware;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.groovy.dsl.GroovyShellUtils;
import com.consol.citrus.groovy.dsl.test.TestCaseScript;
import com.consol.citrus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class GroovyTestLoader
extends DefaultTestLoader
implements TestSourceAware {
    private String source;

    protected void doLoad() {
        try {
            Resource scriptSource = FileUtils.getFileResource((String)this.getSource(), (TestContext)this.context);
            ImportCustomizer ic = new ImportCustomizer();
            String basePath = scriptSource.getFile().getParent();
            if (scriptSource instanceof ClassPathResource) {
                basePath = FileUtils.getBasePath((String)((ClassPathResource)scriptSource).getPath());
            }
            this.testCase = this.runner.getTestCase();
            this.configurer.forEach(it -> it.accept(this.testCase));
            this.runner.start();
            GroovyShellUtils.run(ic, new TestCaseScript(this.citrus, this.runner, this.context, basePath), FileUtils.readToString((Resource)scriptSource), this.citrus, this.context);
            this.handler.forEach(it -> it.accept(this.testCase));
        }
        catch (IOException e) {
            throw this.citrusContext.getTestContextFactory().getObject().handleError(this.testName, this.packageName, "Failed to load Groovy test source '" + this.testName + "'", (Exception)e);
        }
    }

    public String getSource() {
        if (StringUtils.hasText((String)this.source)) {
            return this.source;
        }
        String path = this.packageName.replace('.', File.separatorChar);
        Object fileName = this.testName.endsWith(".groovy") ? this.testName : this.testName + ".groovy";
        return "classpath:" + path + File.separator + (String)fileName;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public GroovyTestLoader source(String source) {
        this.setSource(source);
        return this;
    }
}

