/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.groovy.dsl.actions;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.groovy.dsl.GroovyShellUtils;
import com.consol.citrus.groovy.dsl.actions.ActionsConfiguration;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class ActionsScript {
    private final String script;
    private final Citrus citrus;

    public ActionsScript(String script, Citrus citrus) {
        this.script = script;
        this.citrus = citrus;
    }

    public void execute(TestActionRunner runner, TestContext context) {
        ImportCustomizer ic = new ImportCustomizer();
        GroovyShellUtils.run(ic, new ActionsConfiguration(runner, context), this.normalize(this.script), this.citrus, context);
    }

    private String normalize(String script) {
        String normalized = GroovyShellUtils.removeComments(script);
        if (ActionsScript.isActionScript(normalized)) {
            if (normalized.startsWith("$(")) {
                return String.format("actions { %s }", normalized);
            }
            return normalized;
        }
        return String.format("actions { $(%s) }", normalized);
    }

    public static boolean isActionScript(String script) {
        return script.startsWith("actions {") || script.startsWith("actions{") || script.startsWith("$actions {") || script.startsWith("$actions{") || script.startsWith("$finally {") || script.startsWith("$finally{") || script.startsWith("$(");
    }
}

