/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.groovy.dsl.configuration;

import com.consol.citrus.Citrus;
import com.consol.citrus.common.InitializingPhase;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.groovy.dsl.GroovyShellUtils;
import com.consol.citrus.groovy.dsl.configuration.beans.BeansConfiguration;
import com.consol.citrus.groovy.dsl.configuration.beans.QueueConfiguration;
import com.consol.citrus.groovy.dsl.configuration.endpoints.EndpointsConfiguration;
import com.consol.citrus.util.FileUtils;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.IOException;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.core.io.Resource;

public class ContextConfiguration {
    private final Citrus citrus;
    private final TestContext context;
    private final String basePath;

    public ContextConfiguration(Citrus citrus, TestContext context, String basePath) {
        this.citrus = citrus;
        this.context = context;
        this.basePath = basePath;
    }

    public void load(Class<?> configClass) {
        this.citrus.getCitrusContext().parseConfiguration(configClass);
    }

    public void load(String pathOrType) {
        try {
            if (pathOrType.endsWith(".groovy")) {
                Resource file = pathOrType.startsWith(".") ? FileUtils.getFileResource((String)(this.basePath + pathOrType.substring(1)), (TestContext)this.context) : FileUtils.getFileResource((String)pathOrType, (TestContext)this.context);
                GroovyShellUtils.run(new ImportCustomizer(), this, FileUtils.readToString((Resource)file), this.citrus, this.context);
            } else {
                this.citrus.getCitrusContext().parseConfiguration(Class.forName(pathOrType));
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CitrusRuntimeException(String.format("Failed to load configuration from file '%s'", pathOrType), (Throwable)e);
        }
    }

    public void configuration(Closure<?> callable) {
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)this);
        callable.call();
    }

    public void beans(@DelegatesTo(value=BeansConfiguration.class) Closure<?> callable) {
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)new BeansConfiguration(this.citrus));
        callable.call();
    }

    public void queues(@DelegatesTo(value=QueueConfiguration.class) Closure<?> callable) {
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)new QueueConfiguration(this.citrus));
        callable.call();
    }

    public void endpoints(@DelegatesTo(value=EndpointsConfiguration.class) Closure<?> callable) {
        EndpointsConfiguration configuration = new EndpointsConfiguration();
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)configuration);
        callable.call();
        configuration.getEndpoints().forEach(endpoint -> {
            if (endpoint instanceof InitializingPhase) {
                ((InitializingPhase)endpoint).initialize();
            }
            this.citrus.getCitrusContext().bind(endpoint.getName(), endpoint);
        });
    }
}

