/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.groovy.dsl.configuration.endpoints;

import com.consol.citrus.endpoint.AbstractEndpointBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.util.function.Supplier;

public class EndpointBuilderWrapper
implements Supplier<Endpoint> {
    private EndpointBuilder<?> builder;
    private final String type;
    private final String endpointName;

    public EndpointBuilderWrapper(String type, String endpointName) {
        this.type = type;
        this.endpointName = endpointName;
    }

    public EndpointBuilder<?> client() {
        return this.resolve(this.type + ".client");
    }

    public EndpointBuilder<?> server() {
        return this.resolve(this.type + ".server");
    }

    public EndpointBuilder<?> synchronous() {
        return this.resolve(this.type + ".sync");
    }

    public EndpointBuilder<?> asynchronous() {
        return this.resolve(this.type + ".async");
    }

    private EndpointBuilder<?> resolve(String name) {
        this.builder = (EndpointBuilder)EndpointBuilder.lookup((String)name).orElseThrow(() -> new CitrusRuntimeException(String.format("Failed to resolve endpoint for type %s", name)));
        if (this.builder instanceof AbstractEndpointBuilder) {
            ((AbstractEndpointBuilder)this.builder).name(this.endpointName);
        }
        return this.builder;
    }

    @Override
    public Endpoint get() {
        if (this.builder != null) {
            return this.builder.build();
        }
        return null;
    }
}

