/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.message;

import com.consol.citrus.util.TypeConversionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.util.MultiValueMap;

public class DelegatingHttpEntityMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private final List<HttpMessageConverter<?>> requestMessageConverters;
    private final List<HttpMessageConverter<?>> responseMessageConverters;
    private HttpMessageConverter<?> defaultRequestMessageConverter;
    private HttpMessageConverter<?> defaultResponseMessageConverter;

    public DelegatingHttpEntityMessageConverter() {
        this(new ArrayList(), new ArrayList());
    }

    public DelegatingHttpEntityMessageConverter(List<HttpMessageConverter<?>> requestMessageConverters, List<HttpMessageConverter<?>> responseMessageConverters) {
        super(MediaType.ALL);
        ByteArrayHttpMessageConverter byteArrayHttpMessageConverter = new ByteArrayHttpMessageConverter();
        byteArrayHttpMessageConverter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_PDF, MediaType.IMAGE_GIF, MediaType.IMAGE_JPEG, MediaType.IMAGE_PNG, MediaType.valueOf((String)"application/zip")));
        if (requestMessageConverters.isEmpty()) {
            requestMessageConverters.add((HttpMessageConverter<?>)byteArrayHttpMessageConverter);
            requestMessageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
            requestMessageConverters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        }
        if (responseMessageConverters.isEmpty()) {
            responseMessageConverters.add((HttpMessageConverter<?>)byteArrayHttpMessageConverter);
            StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
            stringHttpMessageConverter.setWriteAcceptCharset(false);
            responseMessageConverters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
            responseMessageConverters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        }
        this.requestMessageConverters = requestMessageConverters;
        this.responseMessageConverters = responseMessageConverters;
        this.defaultRequestMessageConverter = new StringHttpMessageConverter();
        this.defaultResponseMessageConverter = new StringHttpMessageConverter();
        ((StringHttpMessageConverter)this.defaultResponseMessageConverter).setWriteAcceptCharset(false);
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        HttpMessageConverter<?> delegate = this.requestMessageConverters.stream().filter(converter -> converter.getSupportedMediaTypes().stream().filter(mediaType -> !mediaType.equals((Object)MediaType.ALL)).anyMatch(mediaType -> mediaType.equals((Object)inputMessage.getHeaders().getContentType()))).findFirst().orElse(this.defaultRequestMessageConverter);
        if (delegate instanceof ByteArrayHttpMessageConverter) {
            return ((ByteArrayHttpMessageConverter)delegate).read(byte[].class, inputMessage);
        }
        if (delegate instanceof StringHttpMessageConverter) {
            return ((StringHttpMessageConverter)delegate).read(String.class, inputMessage);
        }
        return delegate.read(null, inputMessage);
    }

    protected void writeInternal(Object responseBody, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        HttpMessageConverter<?> delegate = this.responseMessageConverters.stream().filter(converter -> converter.getSupportedMediaTypes().stream().filter(mediaType -> !mediaType.equals((Object)MediaType.ALL)).anyMatch(mediaType -> mediaType.equals((Object)outputMessage.getHeaders().getContentType()))).findFirst().orElse(this.defaultResponseMessageConverter);
        if (delegate instanceof ByteArrayHttpMessageConverter) {
            ((ByteArrayHttpMessageConverter)delegate).write(TypeConversionUtils.convertIfNecessary((Object)responseBody, byte[].class), outputMessage.getHeaders().getContentType(), outputMessage);
        } else if (delegate instanceof StringHttpMessageConverter) {
            ((StringHttpMessageConverter)delegate).write(TypeConversionUtils.convertIfNecessary((Object)responseBody, String.class), outputMessage.getHeaders().getContentType(), outputMessage);
        } else if (delegate instanceof FormHttpMessageConverter) {
            ((FormHttpMessageConverter)delegate).write((MultiValueMap)TypeConversionUtils.convertIfNecessary((Object)responseBody, MultiValueMap.class), outputMessage.getHeaders().getContentType(), outputMessage);
        } else {
            throw new HttpMessageNotWritableException(String.format("Failed to find proper message converter for contentType '%s'", outputMessage.getHeaders().getContentType()));
        }
    }

    public void setBinaryMediaTypes(List<MediaType> binaryMediaTypes) {
        this.requestMessageConverters.stream().filter(converter -> converter instanceof ByteArrayHttpMessageConverter).map(ByteArrayHttpMessageConverter.class::cast).forEach(converter -> converter.setSupportedMediaTypes(binaryMediaTypes));
        this.responseMessageConverters.stream().filter(converter -> converter instanceof ByteArrayHttpMessageConverter).map(ByteArrayHttpMessageConverter.class::cast).forEach(converter -> converter.setSupportedMediaTypes(binaryMediaTypes));
    }
}

