/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.http.client.HttpEndpointConfiguration;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageConverter;
import com.consol.citrus.message.MessageHeaderUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class HttpMessageConverter
implements MessageConverter<HttpEntity<?>, HttpEndpointConfiguration> {
    public HttpEntity<?> convertOutbound(Message message, HttpEndpointConfiguration endpointConfiguration, TestContext context) {
        HttpMessage httpMessage = message instanceof HttpMessage ? (HttpMessage)message : new HttpMessage(message);
        HttpHeaders httpHeaders = new HttpHeaders();
        endpointConfiguration.getHeaderMapper().fromHeaders(new MessageHeaders(httpMessage.getHeaders()), (Object)httpHeaders);
        Map messageHeaders = httpMessage.getHeaders();
        for (Map.Entry header : messageHeaders.entrySet()) {
            if (((String)header.getKey()).startsWith("citrus_") || MessageHeaderUtils.isSpringInternalHeader((String)((String)header.getKey())) || httpHeaders.containsKey(header.getKey())) continue;
            httpHeaders.add((String)header.getKey(), header.getValue().toString());
        }
        if (httpHeaders.getFirst("Content-Type") == null) {
            httpHeaders.add("Content-Type", endpointConfiguration.getContentType().contains("charset") || !StringUtils.hasText((String)endpointConfiguration.getCharset()) ? endpointConfiguration.getContentType() : endpointConfiguration.getContentType() + ";charset=" + endpointConfiguration.getCharset());
        }
        Object payload = httpMessage.getPayload();
        if (httpMessage.getStatusCode() != null) {
            return new ResponseEntity(payload, (MultiValueMap)httpHeaders, httpMessage.getStatusCode());
        }
        for (Cookie cookie : httpMessage.getCookies()) {
            httpHeaders.set("Cookie", cookie.getName() + "=" + context.replaceDynamicContentInString(cookie.getValue()));
        }
        HttpMethod method = endpointConfiguration.getRequestMethod();
        if (httpMessage.getRequestMethod() != null) {
            method = httpMessage.getRequestMethod();
        }
        if (this.httpMethodSupportsBody(method)) {
            return new HttpEntity(payload, (MultiValueMap)httpHeaders);
        }
        return new HttpEntity((MultiValueMap)httpHeaders);
    }

    private boolean httpMethodSupportsBody(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method) || HttpMethod.PUT.equals((Object)method) || HttpMethod.DELETE.equals((Object)method) || HttpMethod.PATCH.equals((Object)method);
    }

    public HttpMessage convertInbound(HttpEntity<?> message, HttpEndpointConfiguration endpointConfiguration, TestContext context) {
        Map mappedHeaders = endpointConfiguration.getHeaderMapper().toHeaders((Object)message.getHeaders());
        HttpMessage httpMessage = new HttpMessage(message.getBody() != null ? message.getBody() : "", this.convertHeaderTypes(mappedHeaders));
        for (Map.Entry<String, String> customHeader : this.getCustomHeaders(message.getHeaders(), mappedHeaders).entrySet()) {
            httpMessage.setHeader(customHeader.getKey(), customHeader.getValue());
        }
        if (message instanceof ResponseEntity) {
            List cookies;
            httpMessage.status(((ResponseEntity)message).getStatusCode());
            httpMessage.version("HTTP/1.1");
            if (endpointConfiguration.isHandleCookies() && (cookies = message.getHeaders().get((Object)"Set-Cookie")) != null) {
                for (String cookieString : cookies) {
                    Cookie cookie = new Cookie(this.getCookieParam("Name", cookieString), this.getCookieParam("Value", cookieString));
                    if (cookieString.contains("Comment")) {
                        cookie.setComment(this.getCookieParam("Comment", cookieString));
                    }
                    if (cookieString.contains("Path")) {
                        cookie.setPath(this.getCookieParam("Path", cookieString));
                    }
                    if (cookieString.contains("Domain")) {
                        cookie.setDomain(this.getCookieParam("Domain", cookieString));
                    }
                    if (cookieString.contains("Max-Age")) {
                        cookie.setMaxAge(Integer.valueOf(this.getCookieParam("Max-Age", cookieString)).intValue());
                    }
                    if (cookieString.contains("Secure")) {
                        cookie.setSecure(Boolean.valueOf(this.getCookieParam("Secure", cookieString)).booleanValue());
                    }
                    if (cookieString.contains("Version")) {
                        cookie.setVersion(Integer.valueOf(this.getCookieParam("Version", cookieString)).intValue());
                    }
                    httpMessage.cookie(cookie);
                }
            }
        }
        return httpMessage;
    }

    private String getCookieParam(String param, String cookieString) {
        if (param.equals("Name")) {
            return cookieString.substring(0, cookieString.indexOf("="));
        }
        if (param.equals("Value")) {
            if (cookieString.contains(";")) {
                return cookieString.substring(cookieString.indexOf("=") + 1, cookieString.indexOf(";"));
            }
            return cookieString.substring(cookieString.indexOf("=") + 1);
        }
        if (cookieString.contains(param + "=")) {
            int endParam = cookieString.indexOf(";", cookieString.indexOf(param + "="));
            if (endParam > 0) {
                return cookieString.substring(cookieString.indexOf(param + "=") + param.length() + 1, endParam);
            }
            return cookieString.substring(cookieString.indexOf(param + "=") + param.length() + 1);
        }
        throw new CitrusRuntimeException(String.format("Unable to get cookie argument '%s' from cookie String: %s", param, cookieString));
    }

    private Map<String, String> getCustomHeaders(HttpHeaders httpHeaders, Map<String, Object> mappedHeaders) {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        for (Map.Entry header : httpHeaders.entrySet()) {
            if (mappedHeaders.containsKey(header.getKey())) continue;
            customHeaders.put((String)header.getKey(), StringUtils.collectionToCommaDelimitedString((Collection)((Collection)header.getValue())));
        }
        return customHeaders;
    }

    private Map<String, Object> convertHeaderTypes(Map<String, Object> headers) {
        HashMap<String, Object> convertedHeaders = new HashMap<String, Object>();
        for (Map.Entry<String, Object> header : headers.entrySet()) {
            if (header.getValue() instanceof Collection) {
                Collection value = (Collection)header.getValue();
                convertedHeaders.put(header.getKey(), StringUtils.collectionToCommaDelimitedString((Collection)value));
                continue;
            }
            if (header.getValue() instanceof MediaType) {
                convertedHeaders.put(header.getKey(), header.getValue().toString());
                continue;
            }
            convertedHeaders.put(header.getKey(), header.getValue());
        }
        return convertedHeaders;
    }

    public void convertOutbound(HttpEntity externalMessage, Message internalMessage, HttpEndpointConfiguration endpointConfiguration, TestContext context) {
        throw new UnsupportedOperationException("HttpMessageConverter does not support predefined HttpEntity objects");
    }
}

