/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.validation.DefaultHeaderValidator;
import com.consol.citrus.validation.context.HeaderValidationContext;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

public class HttpQueryParamHeaderValidator
extends DefaultHeaderValidator {
    public void validateHeader(String name, Object received, Object control, TestContext context, HeaderValidationContext validationContext) {
        Map<String, String> receiveParams = this.convertToMap(received);
        Map<String, String> controlParams = this.convertToMap(control);
        for (Map.Entry<String, String> param : controlParams.entrySet()) {
            if (!receiveParams.containsKey(param.getKey())) {
                throw new ValidationException("Validation failed: Query param '" + param.getKey() + "' is missing");
            }
            super.validateHeader("citrus_http_query_params(" + param.getKey() + ")", (Object)receiveParams.get(param.getKey()), (Object)param.getValue(), context, validationContext);
        }
    }

    private Map<String, String> convertToMap(Object expression) {
        if (expression instanceof Map) {
            return (Map)expression;
        }
        return Stream.of(Optional.ofNullable(expression).map(Object::toString).orElse("").split(",")).map(keyValue -> Optional.ofNullable(StringUtils.split((String)keyValue, (String)"=")).orElse(new String[]{keyValue, ""})).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1]));
    }

    public boolean supports(String headerName, Class<?> type) {
        return headerName.equals("citrus_http_query_params");
    }
}

