/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.client;

import com.consol.citrus.endpoint.AbstractEndpointBuilder;
import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.http.client.HttpClient;
import com.consol.citrus.http.message.HttpMessageConverter;
import com.consol.citrus.message.ErrorHandlingStrategy;
import com.consol.citrus.message.MessageCorrelator;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.web.client.RestTemplate;

public class HttpClientBuilder
extends AbstractEndpointBuilder<HttpClient> {
    private HttpClient endpoint = new HttpClient();

    protected HttpClient getEndpoint() {
        return this.endpoint;
    }

    public HttpClientBuilder requestUrl(String uri) {
        this.endpoint.getEndpointConfiguration().setRequestUrl(uri);
        return this;
    }

    public HttpClientBuilder restTemplate(RestTemplate restTemplate) {
        this.endpoint.getEndpointConfiguration().setRestTemplate(restTemplate);
        return this;
    }

    public HttpClientBuilder requestFactory(ClientHttpRequestFactory requestFactory) {
        this.endpoint.getEndpointConfiguration().setRequestFactory(requestFactory);
        return this;
    }

    public HttpClientBuilder requestMethod(HttpMethod requestMethod) {
        this.endpoint.getEndpointConfiguration().setRequestMethod(requestMethod);
        return this;
    }

    public HttpClientBuilder messageConverter(HttpMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public HttpClientBuilder correlator(MessageCorrelator correlator) {
        this.endpoint.getEndpointConfiguration().setCorrelator(correlator);
        return this;
    }

    public HttpClientBuilder endpointResolver(EndpointUriResolver resolver) {
        this.endpoint.getEndpointConfiguration().setEndpointUriResolver(resolver);
        return this;
    }

    public HttpClientBuilder charset(String charset) {
        this.endpoint.getEndpointConfiguration().setCharset(charset);
        return this;
    }

    public HttpClientBuilder defaultAcceptHeader(boolean flag) {
        this.endpoint.getEndpointConfiguration().setDefaultAcceptHeader(flag);
        return this;
    }

    public HttpClientBuilder contentType(String contentType) {
        this.endpoint.getEndpointConfiguration().setContentType(contentType);
        return this;
    }

    public HttpClientBuilder pollingInterval(int pollingInterval) {
        this.endpoint.getEndpointConfiguration().setPollingInterval(pollingInterval);
        return this;
    }

    public HttpClientBuilder errorHandlingStrategy(ErrorHandlingStrategy errorStrategy) {
        this.endpoint.getEndpointConfiguration().setErrorHandlingStrategy(errorStrategy);
        return this;
    }

    public HttpClientBuilder interceptors(List<ClientHttpRequestInterceptor> interceptors) {
        this.endpoint.getEndpointConfiguration().setClientInterceptors(interceptors);
        return this;
    }

    public HttpClientBuilder interceptor(ClientHttpRequestInterceptor interceptor) {
        if (this.endpoint.getEndpointConfiguration().getClientInterceptors() == null) {
            this.endpoint.getEndpointConfiguration().setClientInterceptors(new ArrayList<ClientHttpRequestInterceptor>());
        }
        this.endpoint.getEndpointConfiguration().getClientInterceptors().add(interceptor);
        return this;
    }

    public HttpClientBuilder headerMapper(DefaultHttpHeaderMapper headerMapper) {
        this.endpoint.getEndpointConfiguration().setHeaderMapper((HeaderMapper<HttpHeaders>)headerMapper);
        return this;
    }

    public HttpClientBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }
}

