/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.config.xml.SendMessageActionParser;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpSendRequestActionParser
extends SendMessageActionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Element body;
        BeanDefinitionBuilder builder = this.parseComponent(element, parserContext);
        builder.addPropertyValue("name", (Object)("http:" + element.getLocalName()));
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)builder);
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)builder, (String)element.getAttribute("actor"), (String)"actor");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)builder, (String)element.getAttribute("fork"), (String)"forkMode");
        HttpMessage httpMessage = new HttpMessage();
        if (!element.hasAttribute("uri") && !element.hasAttribute("client")) {
            throw new BeanCreationException("Neither http request uri nor http client endpoint reference is given - invalid test action definition");
        }
        if (element.hasAttribute("client")) {
            builder.addPropertyReference("endpoint", element.getAttribute("client"));
        }
        if (element.hasAttribute("uri")) {
            if (!element.hasAttribute("client")) {
                builder.addPropertyValue("endpointUri", (Object)element.getAttribute("uri"));
            } else {
                httpMessage.setHeader("citrus_endpoint_uri", element.getAttribute("uri"));
            }
        }
        Element requestElement = (Element)DomUtils.getChildElements((Element)element).get(0);
        httpMessage.method(HttpMethod.valueOf((String)requestElement.getLocalName().toUpperCase()));
        if (requestElement.hasAttribute("path")) {
            httpMessage.path(requestElement.getAttribute("path"));
        }
        List params = DomUtils.getChildElementsByTagName((Element)requestElement, (String)"param");
        for (Element param : params) {
            httpMessage.queryParam(param.getAttribute("name"), param.getAttribute("value"));
        }
        Element headers = DomUtils.getChildElementByTagName((Element)requestElement, (String)"headers");
        if (headers != null) {
            String version;
            String accept;
            List headerElements = DomUtils.getChildElementsByTagName((Element)headers, (String)"header");
            for (Element header : headerElements) {
                httpMessage.setHeader(header.getAttribute("name"), header.getAttribute("value"));
            }
            String contentType = headers.getAttribute("content-type");
            if (StringUtils.hasText((String)contentType)) {
                httpMessage.contentType(contentType);
            }
            if (StringUtils.hasText((String)(accept = headers.getAttribute("accept")))) {
                httpMessage.accept(accept);
            }
            if (StringUtils.hasText((String)(version = headers.getAttribute("version")))) {
                httpMessage.version(version);
            }
        }
        if ((body = DomUtils.getChildElementByTagName((Element)requestElement, (String)"body")) != null) {
            String dataDictionary;
            String messageType = body.getAttribute("type");
            if (StringUtils.hasText((String)messageType)) {
                builder.addPropertyValue("messageType", (Object)messageType);
            }
            if (StringUtils.hasText((String)(dataDictionary = body.getAttribute("data-dictionary")))) {
                builder.addPropertyReference("dataDictionary", dataDictionary);
            }
        }
        AbstractMessageContentBuilder messageBuilder = this.constructMessageBuilder(body);
        Map messageHeaders = httpMessage.getHeaders();
        messageHeaders.remove("citrus_message_id");
        messageHeaders.remove("citrus_message_timestamp");
        messageBuilder.setMessageHeaders(messageHeaders);
        builder.addPropertyValue("messageBuilder", (Object)messageBuilder);
        ArrayList variableExtractors = new ArrayList();
        this.parseExtractHeaderElements(element, variableExtractors);
        if (!variableExtractors.isEmpty()) {
            builder.addPropertyValue("variableExtractors", variableExtractors);
        }
        return builder.getBeanDefinition();
    }
}

