/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.message;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class HttpMessage
extends DefaultMessage {
    public HttpMessage() {
    }

    public HttpMessage(Message message) {
        super(message);
    }

    public HttpMessage(Object payload) {
        super(payload);
    }

    public HttpMessage(Object payload, Map<String, Object> headers) {
        super(payload, headers);
    }

    public HttpMessage method(HttpMethod method) {
        this.setHeader("citrus_http_method", method.name());
        return this;
    }

    public HttpMessage version(String version) {
        this.setHeader("citrus_http_version", version);
        return this;
    }

    public HttpMessage status(HttpStatus statusCode) {
        this.statusCode(statusCode.value());
        this.reasonPhrase(statusCode.name());
        return this;
    }

    public HttpMessage statusCode(Integer statusCode) {
        this.setHeader("citrus_http_status_code", statusCode);
        return this;
    }

    public HttpMessage reasonPhrase(String reasonPhrase) {
        this.setHeader("citrus_http_reason_phrase", reasonPhrase);
        return this;
    }

    public HttpMessage uri(String requestUri) {
        this.setHeader("citrus_endpoint_uri", requestUri);
        this.setHeader("citrus_http_request_uri", requestUri);
        return this;
    }

    public HttpMessage contentType(String contentType) {
        this.setHeader("Content-Type", contentType);
        return this;
    }

    public HttpMessage accept(String accept) {
        this.setHeader("Accept", accept);
        return this;
    }

    public HttpMessage contextPath(String contextPath) {
        this.setHeader("citrus_http_context_path", contextPath);
        return this;
    }

    public HttpMessage queryParams(String queryParamString) {
        this.header("citrus_http_query_params", queryParamString);
        this.header("citrus_query_params", queryParamString);
        return this;
    }

    public HttpMessage queryParam(String name, String value) {
        String queryParams;
        if (!StringUtils.hasText((String)name)) {
            throw new CitrusRuntimeException("Invalid query param name - must not be empty!");
        }
        if (this.getHeader("citrus_http_query_params") != null) {
            queryParams = this.getHeader("citrus_http_query_params").toString();
            queryParams = queryParams + "," + name + "=" + value;
        } else {
            queryParams = name + "=" + value;
        }
        this.header("citrus_http_query_params", queryParams);
        this.header("citrus_query_params", queryParams);
        return this;
    }

    public HttpMessage path(String path) {
        this.header("citrus_http_request_uri", path);
        this.header("citrus_request_path", path);
        return this;
    }

    public HttpMessage header(String headerName, Object headerValue) {
        return (HttpMessage)super.setHeader(headerName, headerValue);
    }

    public HttpMessage setHeader(String headerName, Object headerValue) {
        return (HttpMessage)super.setHeader(headerName, headerValue);
    }

    public HttpMethod getRequestMethod() {
        Object method = this.getHeader("citrus_http_method");
        if (method != null) {
            return HttpMethod.valueOf((String)method.toString());
        }
        return null;
    }

    public String getUri() {
        Object requestUri = this.getHeader("citrus_http_request_uri");
        if (requestUri != null) {
            return requestUri.toString();
        }
        return null;
    }

    public String getContextPath() {
        Object contextPath = this.getHeader("citrus_http_context_path");
        if (contextPath != null) {
            return contextPath.toString();
        }
        return null;
    }

    public String getQueryParams() {
        Object queryParams = this.getHeader("citrus_http_query_params");
        if (queryParams != null) {
            return queryParams.toString();
        }
        return null;
    }

    public HttpStatus getStatusCode() {
        Object statusCode = this.getHeader("citrus_http_status_code");
        if (statusCode != null) {
            if (statusCode instanceof HttpStatus) {
                return (HttpStatus)statusCode;
            }
            if (statusCode instanceof Integer) {
                return HttpStatus.valueOf((int)((Integer)statusCode));
            }
            return HttpStatus.valueOf((int)Integer.valueOf(statusCode.toString()));
        }
        return null;
    }

    public String getReasonPhrase() {
        Object reasonPhrase = this.getHeader("citrus_http_reason_phrase");
        if (reasonPhrase != null) {
            return reasonPhrase.toString();
        }
        return null;
    }

    public String getVersion() {
        Object version = this.getHeader("citrus_http_version");
        if (version != null) {
            return version.toString();
        }
        return null;
    }

    public String getPath() {
        Object path = this.getHeader("citrus_request_path");
        if (path != null) {
            return path.toString();
        }
        return null;
    }
}

