/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.controller;

import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.adapter.EmptyResponseEndpointAdapter;
import com.consol.citrus.http.client.HttpEndpointConfiguration;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import java.util.Enumeration;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UrlPathHelper;

@Controller
@RequestMapping(value={"/*"})
public class HttpMessageController {
    private EndpointAdapter endpointAdapter = new EmptyResponseEndpointAdapter();
    private HttpEndpointConfiguration endpointConfiguration = new HttpEndpointConfiguration();
    private ConcurrentLinkedQueue<ResponseEntity<?>> responseCache = new ConcurrentLinkedQueue();

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> handleGetRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.GET, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> handlePostRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.POST, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> handlePutRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.PUT, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> handleDeleteRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.DELETE, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.OPTIONS})
    @ResponseBody
    public ResponseEntity<?> handleOptionsRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.OPTIONS, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.HEAD})
    @ResponseBody
    public ResponseEntity<?> handleHeadRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.HEAD, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.TRACE})
    @ResponseBody
    public ResponseEntity<?> handleTraceRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.TRACE, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.PATCH})
    @ResponseBody
    public ResponseEntity<?> handlePatchRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.PATCH, requestEntity);
    }

    private ResponseEntity<?> handleRequestInternal(HttpMethod method, HttpEntity<?> requestEntity) {
        ResponseEntity responseEntity;
        HttpMessage request = this.endpointConfiguration.getMessageConverter().convertInbound(requestEntity, this.endpointConfiguration, null);
        HttpServletRequest servletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        UrlPathHelper pathHelper = new UrlPathHelper();
        Enumeration allHeaders = servletRequest.getHeaderNames();
        for (String headerName : (String[])CollectionUtils.toArray((Enumeration)allHeaders, (Object[])new String[0])) {
            if (request.getHeader(headerName) != null) continue;
            String headerValue = servletRequest.getHeader(headerName);
            request.header(headerName, headerValue != null ? headerValue : "");
        }
        if (this.endpointConfiguration.isHandleCookies()) {
            request.setCookies(servletRequest.getCookies());
        }
        if (this.endpointConfiguration.isHandleAttributeHeaders()) {
            Enumeration attributeNames = servletRequest.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                Object attribute = servletRequest.getAttribute(attributeName);
                request.setHeader(attributeName, attribute);
            }
        }
        request.path(pathHelper.getRequestUri(servletRequest)).uri(pathHelper.getRequestUri(servletRequest)).contextPath(pathHelper.getContextPath(servletRequest)).queryParams(Optional.ofNullable(pathHelper.getOriginatingQueryString(servletRequest)).map(queryString -> queryString.replaceAll("&", ",")).orElse("")).version(servletRequest.getProtocol()).method(method);
        Message response = this.endpointAdapter.handleMessage((Message)request);
        if (response == null) {
            responseEntity = new ResponseEntity(HttpStatus.valueOf((int)this.endpointConfiguration.getDefaultStatusCode()));
        } else {
            HttpMessage httpResponse = response instanceof HttpMessage ? (HttpMessage)response : new HttpMessage(response);
            if (httpResponse.getStatusCode() == null) {
                httpResponse.status(HttpStatus.valueOf((int)this.endpointConfiguration.getDefaultStatusCode()));
            }
            responseEntity = (ResponseEntity)this.endpointConfiguration.getMessageConverter().convertOutbound((Message)httpResponse, this.endpointConfiguration, null);
            if (this.endpointConfiguration.isHandleCookies() && httpResponse.getCookies() != null) {
                HttpServletResponse servletResponse = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
                for (Cookie cookie : httpResponse.getCookies()) {
                    servletResponse.addCookie(cookie);
                }
            }
        }
        this.responseCache.add(responseEntity);
        return responseEntity;
    }

    public void setEndpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpointAdapter = endpointAdapter;
    }

    public EndpointAdapter getEndpointAdapter() {
        return this.endpointAdapter;
    }

    public HttpEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void setEndpointConfiguration(HttpEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    public ResponseEntity<?> getResponseCache() {
        return this.responseCache.poll();
    }
}

