/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.actions;

import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageContentBuilder;
import com.consol.citrus.http.message.HttpMessageUtils;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;

public class HttpClientRequestActionBuilder
extends SendMessageAction.SendMessageActionBuilder<SendMessageAction, HttpClientRequestActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpClientRequestActionBuilder() {
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)this.httpMessage);
        staticMessageContentBuilder.setMessageHeaders(this.httpMessage.getHeaders());
        this.messageBuilder((MessageContentBuilder)new HttpMessageContentBuilder(this.httpMessage, (AbstractMessageContentBuilder)staticMessageContentBuilder));
    }

    protected void setPayload(String payload) {
        this.httpMessage.setPayload(payload);
    }

    public HttpClientRequestActionBuilder payload(MultiValueMap<String, Object> payload) {
        this.httpMessage.setPayload(payload);
        return this;
    }

    public HttpClientRequestActionBuilder messageName(String name) {
        this.httpMessage.setName(name);
        return (HttpClientRequestActionBuilder)super.messageName(name);
    }

    public HttpClientRequestActionBuilder path(String path) {
        this.httpMessage.path(path);
        return this;
    }

    public HttpClientRequestActionBuilder method(HttpMethod method) {
        this.httpMessage.method(method);
        return this;
    }

    public HttpClientRequestActionBuilder uri(String uri) {
        this.httpMessage.uri(uri);
        return this;
    }

    public HttpClientRequestActionBuilder queryParam(String name) {
        this.httpMessage.queryParam(name, null);
        return this;
    }

    public HttpClientRequestActionBuilder queryParam(String name, String value) {
        this.httpMessage.queryParam(name, value);
        return this;
    }

    public HttpClientRequestActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpClientRequestActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }

    public HttpClientRequestActionBuilder accept(String accept) {
        this.httpMessage.accept(accept);
        return this;
    }

    public HttpClientRequestActionBuilder cookie(Cookie cookie) {
        this.httpMessage.cookie(cookie);
        return this;
    }

    public HttpClientRequestActionBuilder message(Message message) {
        HttpMessageUtils.copy(message, this.httpMessage);
        return this;
    }

    public SendMessageAction build() {
        return new SendMessageAction((SendMessageAction.SendMessageActionBuilder)this);
    }
}

