/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.actions;

import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageContentBuilder;
import com.consol.citrus.http.message.HttpMessageUtils;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import java.util.Optional;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpStatus;

public class HttpClientResponseActionBuilder
extends ReceiveMessageAction.ReceiveMessageActionBuilder<ReceiveMessageAction, HttpClientResponseActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpClientResponseActionBuilder() {
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)this.httpMessage);
        staticMessageContentBuilder.setMessageHeaders(this.httpMessage.getHeaders());
        this.messageBuilder(new HttpMessageContentBuilder(this.httpMessage, (AbstractMessageContentBuilder)staticMessageContentBuilder));
        this.headerNameIgnoreCase(true);
    }

    protected void setPayload(String payload) {
        this.httpMessage.setPayload(payload);
    }

    public HttpClientResponseActionBuilder messageName(String name) {
        this.httpMessage.setName(name);
        return (HttpClientResponseActionBuilder)super.messageName(name);
    }

    public HttpClientResponseActionBuilder status(HttpStatus status) {
        this.httpMessage.status(status);
        return this;
    }

    public HttpClientResponseActionBuilder statusCode(Integer statusCode) {
        this.httpMessage.statusCode(statusCode);
        return this;
    }

    public HttpClientResponseActionBuilder reasonPhrase(String reasonPhrase) {
        this.httpMessage.reasonPhrase(reasonPhrase);
        return this;
    }

    public HttpClientResponseActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpClientResponseActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }

    public HttpClientResponseActionBuilder cookie(Cookie cookie) {
        this.httpMessage.cookie(cookie);
        return this;
    }

    public HttpClientResponseActionBuilder message(Message message) {
        HttpMessageUtils.copy(message, this.httpMessage);
        return this;
    }

    public ReceiveMessageAction doBuild() {
        return new ReceiveMessageAction((ReceiveMessageAction.ReceiveMessageActionBuilder)this);
    }

    protected Optional<String> getMessagePayload() {
        if (this.httpMessage.getPayload() instanceof String) {
            return Optional.of(this.httpMessage.getPayload(String.class));
        }
        return super.getMessagePayload();
    }
}

