/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.actions;

import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageContentBuilder;
import com.consol.citrus.http.message.HttpMessageUtils;
import com.consol.citrus.http.message.HttpQueryParamHeaderValidator;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.HeaderValidator;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import java.util.Optional;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpMethod;

public class HttpServerRequestActionBuilder
extends ReceiveMessageAction.ReceiveMessageActionBuilder<ReceiveMessageAction, HttpServerRequestActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpServerRequestActionBuilder() {
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)this.httpMessage);
        staticMessageContentBuilder.setMessageHeaders(this.httpMessage.getHeaders());
        this.messageBuilder(new HttpMessageContentBuilder(this.httpMessage, (AbstractMessageContentBuilder)staticMessageContentBuilder));
        this.headerNameIgnoreCase(true);
        this.headerValidator(new HeaderValidator[]{new HttpQueryParamHeaderValidator()});
    }

    protected void setPayload(String payload) {
        this.httpMessage.setPayload(payload);
    }

    public HttpServerRequestActionBuilder messageName(String name) {
        this.httpMessage.setName(name);
        return (HttpServerRequestActionBuilder)super.messageName(name);
    }

    public HttpServerRequestActionBuilder path(String path) {
        this.httpMessage.path(path);
        return this;
    }

    public HttpServerRequestActionBuilder method(HttpMethod method) {
        this.httpMessage.method(method);
        return this;
    }

    public HttpServerRequestActionBuilder queryParam(String name) {
        this.httpMessage.queryParam(name, null);
        return this;
    }

    public HttpServerRequestActionBuilder queryParam(String name, String value) {
        this.httpMessage.queryParam(name, value);
        return this;
    }

    public HttpServerRequestActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpServerRequestActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }

    public HttpServerRequestActionBuilder accept(String accept) {
        this.httpMessage.accept(accept);
        return this;
    }

    public HttpServerRequestActionBuilder cookie(Cookie cookie) {
        this.httpMessage.cookie(cookie);
        return this;
    }

    public HttpServerRequestActionBuilder message(Message message) {
        HttpMessageUtils.copy(message, this.httpMessage);
        return this;
    }

    public ReceiveMessageAction doBuild() {
        return new ReceiveMessageAction((ReceiveMessageAction.ReceiveMessageActionBuilder)this);
    }

    protected Optional<String> getMessagePayload() {
        if (this.httpMessage.getPayload() instanceof String) {
            return Optional.of(this.httpMessage.getPayload(String.class));
        }
        return super.getMessagePayload();
    }
}

