/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.actions;

import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageContentBuilder;
import com.consol.citrus.http.message.HttpMessageUtils;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpStatus;

public class HttpServerResponseActionBuilder
extends SendMessageAction.SendMessageActionBuilder<SendMessageAction, HttpServerResponseActionBuilder> {
    private HttpMessage httpMessage = new HttpMessage();

    public HttpServerResponseActionBuilder() {
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)this.httpMessage);
        staticMessageContentBuilder.setMessageHeaders(this.httpMessage.getHeaders());
        this.messageBuilder((MessageContentBuilder)new HttpMessageContentBuilder(this.httpMessage, (AbstractMessageContentBuilder)staticMessageContentBuilder));
    }

    protected void setPayload(String payload) {
        this.httpMessage.setPayload(payload);
    }

    public HttpServerResponseActionBuilder messageName(String name) {
        this.httpMessage.setName(name);
        return (HttpServerResponseActionBuilder)super.messageName(name);
    }

    public HttpServerResponseActionBuilder status(HttpStatus status) {
        this.httpMessage.status(status);
        return this;
    }

    public HttpServerResponseActionBuilder statusCode(Integer statusCode) {
        this.httpMessage.statusCode(statusCode);
        return this;
    }

    public HttpServerResponseActionBuilder reasonPhrase(String reasonPhrase) {
        this.httpMessage.reasonPhrase(reasonPhrase);
        return this;
    }

    public HttpServerResponseActionBuilder version(String version) {
        this.httpMessage.version(version);
        return this;
    }

    public HttpServerResponseActionBuilder contentType(String contentType) {
        this.httpMessage.contentType(contentType);
        return this;
    }

    public HttpServerResponseActionBuilder cookie(Cookie cookie) {
        this.httpMessage.cookie(cookie);
        return this;
    }

    public HttpServerResponseActionBuilder message(Message message) {
        HttpMessageUtils.copy(message, this.httpMessage);
        return this;
    }

    public SendMessageAction build() {
        return new SendMessageAction((SendMessageAction.SendMessageActionBuilder)this);
    }
}

