/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.http.client.HttpClient;
import com.consol.citrus.http.client.HttpClientBuilder;
import com.consol.citrus.http.config.annotation.HttpClientConfig;
import com.consol.citrus.http.message.HttpMessageConverter;
import com.consol.citrus.message.MessageCorrelator;
import com.consol.citrus.spi.ReferenceResolver;
import java.util.ArrayList;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpClientConfigParser
extends AbstractAnnotationConfigParser<HttpClientConfig, HttpClient> {
    public HttpClientConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public HttpClient parse(HttpClientConfig annotation) {
        HttpClientBuilder builder = new HttpClientBuilder();
        if (StringUtils.hasText((String)annotation.restTemplate()) && StringUtils.hasText((String)annotation.requestFactory())) {
            throw new CitrusRuntimeException("When providing a 'rest-template' property, no 'request-factory' should be set!");
        }
        if (!StringUtils.hasText((String)annotation.requestUrl()) && !StringUtils.hasText((String)annotation.endpointResolver())) {
            throw new CitrusRuntimeException("One of the properties 'request-url' or 'endpoint-resolver' is required!");
        }
        if (StringUtils.hasText((String)annotation.restTemplate())) {
            builder.restTemplate((RestTemplate)this.getReferenceResolver().resolve(annotation.restTemplate(), RestTemplate.class));
        }
        if (StringUtils.hasText((String)annotation.requestFactory())) {
            builder.requestFactory((ClientHttpRequestFactory)this.getReferenceResolver().resolve(annotation.requestFactory(), ClientHttpRequestFactory.class));
        }
        builder.requestUrl(annotation.requestUrl());
        builder.requestMethod(annotation.requestMethod());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((HttpMessageConverter)this.getReferenceResolver().resolve(annotation.messageConverter(), HttpMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)this.getReferenceResolver().resolve(annotation.correlator(), MessageCorrelator.class));
        }
        if (StringUtils.hasText((String)annotation.endpointResolver())) {
            builder.endpointResolver((EndpointUriResolver)this.getReferenceResolver().resolve(annotation.endpointResolver(), EndpointUriResolver.class));
        }
        builder.defaultAcceptHeader(annotation.defaultAcceptHeader());
        builder.handleCookies(annotation.handleCookies());
        builder.charset(annotation.charset());
        builder.contentType(annotation.contentType());
        builder.pollingInterval(annotation.pollingInterval());
        builder.errorHandlingStrategy(annotation.errorStrategy());
        if (StringUtils.hasText((String)annotation.errorHandler())) {
            builder.errorHandler((ResponseErrorHandler)this.getReferenceResolver().resolve(annotation.errorHandler(), ResponseErrorHandler.class));
        }
        ArrayList<MediaType> binaryMediaTypes = new ArrayList<MediaType>();
        for (String mediaType : annotation.binaryMediaTypes()) {
            binaryMediaTypes.add(MediaType.valueOf((String)mediaType));
        }
        if (!binaryMediaTypes.isEmpty()) {
            builder.binaryMediaTypes(binaryMediaTypes);
        }
        if (annotation.interceptors().length > 0) {
            builder.interceptors(this.getReferenceResolver().resolve(annotation.interceptors(), ClientHttpRequestInterceptor.class));
        }
        builder.headerMapper(DefaultHttpHeaderMapper.outboundMapper());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (HttpClient)builder.initialize().build();
    }
}

