/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.interceptor;

import com.consol.citrus.message.Message;
import com.consol.citrus.message.RawMessage;
import com.consol.citrus.report.MessageListeners;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class LoggingClientInterceptor
implements ClientHttpRequestInterceptor {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static Logger log = LoggerFactory.getLogger(LoggingClientInterceptor.class);
    private MessageListeners messageListener;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.handleRequest(this.getRequestContent(request, new String(body)));
        ClientHttpResponse response = execution.execute(request, body);
        CachingClientHttpResponseWrapper bufferedResponse = new CachingClientHttpResponseWrapper(response);
        this.handleResponse(this.getResponseContent(bufferedResponse));
        return bufferedResponse;
    }

    public void handleRequest(String request) {
        if (this.hasMessageListeners()) {
            log.debug("Sending Http request message");
            this.messageListener.onOutboundMessage((Message)new RawMessage(request), null);
        } else if (log.isDebugEnabled()) {
            log.debug("Sending Http request message:" + NEWLINE + request);
        }
    }

    public void handleResponse(String response) {
        if (this.hasMessageListeners()) {
            log.debug("Received Http response message");
            this.messageListener.onInboundMessage((Message)new RawMessage(response), null);
        } else if (log.isDebugEnabled()) {
            log.debug("Received Http response message:" + NEWLINE + response);
        }
    }

    public boolean hasMessageListeners() {
        return this.messageListener != null && !this.messageListener.isEmpty();
    }

    private String getRequestContent(HttpRequest request, String body) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getMethod());
        builder.append(" ");
        builder.append(request.getURI());
        builder.append(NEWLINE);
        this.appendHeaders(request.getHeaders(), builder);
        builder.append(NEWLINE);
        builder.append(body);
        return builder.toString();
    }

    private String getResponseContent(CachingClientHttpResponseWrapper response) throws IOException {
        if (response != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("HTTP/1.1 ");
            builder.append(response.getStatusCode());
            builder.append(" ");
            builder.append(response.getStatusText());
            builder.append(NEWLINE);
            this.appendHeaders(response.getHeaders(), builder);
            builder.append(NEWLINE);
            builder.append(response.getBodyContent());
            return builder.toString();
        }
        return "";
    }

    private void appendHeaders(HttpHeaders headers, StringBuilder builder) {
        for (Map.Entry headerEntry : headers.entrySet()) {
            builder.append((String)headerEntry.getKey());
            builder.append(":");
            builder.append(StringUtils.arrayToCommaDelimitedString((Object[])((List)headerEntry.getValue()).toArray()));
            builder.append(NEWLINE);
        }
    }

    public void setMessageListener(MessageListeners messageListener) {
        this.messageListener = messageListener;
    }

    private static final class CachingClientHttpResponseWrapper
    implements ClientHttpResponse {
        private final ClientHttpResponse response;
        private byte[] body;

        CachingClientHttpResponseWrapper(ClientHttpResponse response) {
            this.response = response;
        }

        public HttpStatus getStatusCode() throws IOException {
            return this.response.getStatusCode();
        }

        public int getRawStatusCode() throws IOException {
            return this.response.getRawStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.response.getStatusText();
        }

        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }

        public InputStream getBody() throws IOException {
            if (this.body == null) {
                this.body = this.response.getBody() != null ? FileCopyUtils.copyToByteArray((InputStream)this.response.getBody()) : new byte[0];
            }
            return new ByteArrayInputStream(this.body);
        }

        public String getBodyContent() throws IOException {
            if (this.body == null) {
                this.getBody();
            }
            return new String(this.body, Charset.forName("UTF-8"));
        }

        public void close() {
            this.response.close();
        }
    }
}

