/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.actions;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.actions.HttpServerRequestActionBuilder;
import com.consol.citrus.http.actions.HttpServerResponseActionBuilder;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HttpServerActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private Endpoint httpServer;
    private String httpServerUri;
    private TestActionBuilder<?> delegate;

    public HttpServerActionBuilder(Endpoint httpServer) {
        this.httpServer = httpServer;
    }

    public HttpServerActionBuilder(String httpServerUri) {
        this.httpServerUri = httpServerUri;
    }

    public HttpServerResponseActionBuilder respond() {
        return new HttpServerSendActionBuilder().response();
    }

    public HttpServerResponseActionBuilder respond(HttpStatus status) {
        return new HttpServerSendActionBuilder().response(status);
    }

    public HttpServerReceiveActionBuilder receive() {
        return new HttpServerReceiveActionBuilder();
    }

    public HttpServerSendActionBuilder send() {
        return new HttpServerSendActionBuilder();
    }

    private HttpServerRequestActionBuilder request(HttpMethod method, String path) {
        HttpServerRequestActionBuilder builder = new HttpServerRequestActionBuilder();
        if (this.httpServer != null) {
            builder.endpoint(this.httpServer);
        } else {
            builder.endpoint(this.httpServerUri);
        }
        builder.withReferenceResolver(this.referenceResolver);
        ((HttpServerRequestActionBuilder.HttpMessageBuilderSupport)builder.message()).method(method);
        if (StringUtils.hasText((String)path)) {
            builder.path(path);
        }
        this.delegate = builder;
        return builder;
    }

    public HttpServerActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }

    public class HttpServerReceiveActionBuilder {
        public HttpServerRequestActionBuilder get() {
            return HttpServerActionBuilder.this.request(HttpMethod.GET, null);
        }

        public HttpServerRequestActionBuilder get(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.GET, path);
        }

        public HttpServerRequestActionBuilder post() {
            return HttpServerActionBuilder.this.request(HttpMethod.POST, null);
        }

        public HttpServerRequestActionBuilder post(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.POST, path);
        }

        public HttpServerRequestActionBuilder put() {
            return HttpServerActionBuilder.this.request(HttpMethod.PUT, null);
        }

        public HttpServerRequestActionBuilder put(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.PUT, path);
        }

        public HttpServerRequestActionBuilder delete() {
            return HttpServerActionBuilder.this.request(HttpMethod.DELETE, null);
        }

        public HttpServerRequestActionBuilder delete(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.DELETE, path);
        }

        public HttpServerRequestActionBuilder head() {
            return HttpServerActionBuilder.this.request(HttpMethod.HEAD, null);
        }

        public HttpServerRequestActionBuilder head(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.HEAD, path);
        }

        public HttpServerRequestActionBuilder options() {
            return HttpServerActionBuilder.this.request(HttpMethod.OPTIONS, null);
        }

        public HttpServerRequestActionBuilder options(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.OPTIONS, path);
        }

        public HttpServerRequestActionBuilder trace() {
            return HttpServerActionBuilder.this.request(HttpMethod.TRACE, null);
        }

        public HttpServerRequestActionBuilder trace(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.TRACE, path);
        }

        public HttpServerRequestActionBuilder patch() {
            return HttpServerActionBuilder.this.request(HttpMethod.PATCH, null);
        }

        public HttpServerRequestActionBuilder patch(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.PATCH, path);
        }
    }

    public class HttpServerSendActionBuilder {
        public HttpServerResponseActionBuilder response() {
            HttpServerResponseActionBuilder builder = new HttpServerResponseActionBuilder();
            if (HttpServerActionBuilder.this.httpServer != null) {
                builder.endpoint(HttpServerActionBuilder.this.httpServer);
            } else {
                builder.endpoint(HttpServerActionBuilder.this.httpServerUri);
            }
            builder.withReferenceResolver(HttpServerActionBuilder.this.referenceResolver);
            HttpServerActionBuilder.this.delegate = (TestActionBuilder)builder;
            return builder;
        }

        public HttpServerResponseActionBuilder response(HttpStatus status) {
            HttpServerResponseActionBuilder builder = new HttpServerResponseActionBuilder();
            if (HttpServerActionBuilder.this.httpServer != null) {
                builder.endpoint(HttpServerActionBuilder.this.httpServer);
            } else {
                builder.endpoint(HttpServerActionBuilder.this.httpServerUri);
            }
            builder.withReferenceResolver(HttpServerActionBuilder.this.referenceResolver);
            ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)builder.message()).status(status);
            HttpServerActionBuilder.this.delegate = (TestActionBuilder)builder;
            return builder;
        }
    }
}

