/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.client;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpointComponent;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.http.client.HttpClient;
import com.consol.citrus.http.client.HttpEndpointConfiguration;
import com.consol.citrus.message.ErrorHandlingStrategy;
import java.util.Map;
import org.springframework.http.HttpMethod;

public class HttpEndpointComponent
extends AbstractEndpointComponent {
    public HttpEndpointComponent() {
        this("http");
    }

    public HttpEndpointComponent(String name) {
        super(name);
    }

    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        HttpClient client = new HttpClient();
        client.getEndpointConfiguration().setRequestUrl(this.getScheme() + resourcePath + this.getParameterString(parameters, HttpEndpointConfiguration.class));
        if (parameters.containsKey("requestMethod")) {
            String method = parameters.remove("requestMethod");
            client.getEndpointConfiguration().setRequestMethod(HttpMethod.valueOf((String)method));
        }
        if (parameters.containsKey("errorHandlingStrategy")) {
            String strategy = parameters.remove("errorHandlingStrategy");
            client.getEndpointConfiguration().setErrorHandlingStrategy(ErrorHandlingStrategy.fromName((String)strategy));
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)client.getEndpointConfiguration(), this.getEndpointConfigurationParameters(parameters, HttpEndpointConfiguration.class), context);
        return client;
    }

    protected String getScheme() {
        return "http://";
    }
}

