/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.server;

import com.consol.citrus.http.message.HttpMessageConverter;
import com.consol.citrus.http.server.HttpServer;
import com.consol.citrus.server.AbstractServerBuilder;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.HandlerInterceptor;

public class AbstractHttpServerBuilder<T extends HttpServer, B extends AbstractHttpServerBuilder<T, B>>
extends AbstractServerBuilder<T, B> {
    private final T endpoint;
    private final B self;

    protected AbstractHttpServerBuilder(T server) {
        this.endpoint = server;
        this.self = this;
    }

    protected T getEndpoint() {
        return this.endpoint;
    }

    public B port(int port) {
        ((HttpServer)((Object)this.endpoint)).setPort(port);
        return this.self;
    }

    public B contextConfigLocation(String configLocation) {
        ((HttpServer)((Object)this.endpoint)).setContextConfigLocation(configLocation);
        return this.self;
    }

    public B resourceBase(String resourceBase) {
        ((HttpServer)((Object)this.endpoint)).setResourceBase(resourceBase);
        return this.self;
    }

    public B rootParentContext(boolean rootParentContext) {
        ((HttpServer)((Object)this.endpoint)).setUseRootContextAsParent(rootParentContext);
        return this.self;
    }

    public B connectors(List<Connector> connectors) {
        ((HttpServer)((Object)this.endpoint)).setConnectors(connectors.toArray(new Connector[connectors.size()]));
        return this.self;
    }

    public B connector(Connector connector) {
        ((HttpServer)((Object)this.endpoint)).setConnector(connector);
        return this.self;
    }

    public B filters(Map<String, Filter> filters) {
        ((HttpServer)((Object)this.endpoint)).setFilters(filters);
        return this.self;
    }

    public B filterMappings(Map<String, String> filterMappings) {
        ((HttpServer)((Object)this.endpoint)).setFilterMappings(filterMappings);
        return this.self;
    }

    public B binaryMediaTypes(List<MediaType> binaryMediaTypes) {
        ((HttpServer)((Object)this.endpoint)).setBinaryMediaTypes(binaryMediaTypes);
        return this.self;
    }

    public B servletName(String servletName) {
        ((HttpServer)((Object)this.endpoint)).setServletName(servletName);
        return this.self;
    }

    public B servletMappingPath(String servletMappingPath) {
        ((HttpServer)((Object)this.endpoint)).setServletMappingPath(servletMappingPath);
        return this.self;
    }

    public B contextPath(String contextPath) {
        ((HttpServer)((Object)this.endpoint)).setContextPath(contextPath);
        return this.self;
    }

    public B servletHandler(ServletHandler servletHandler) {
        ((HttpServer)((Object)this.endpoint)).setServletHandler(servletHandler);
        return this.self;
    }

    public B securityHandler(SecurityHandler securityHandler) {
        ((HttpServer)((Object)this.endpoint)).setSecurityHandler(securityHandler);
        return this.self;
    }

    public B messageConverter(HttpMessageConverter messageConverter) {
        ((HttpServer)((Object)this.endpoint)).setMessageConverter(messageConverter);
        return this.self;
    }

    public B handleAttributeHeaders(boolean flag) {
        ((HttpServer)((Object)this.endpoint)).setHandleAttributeHeaders(flag);
        return this.self;
    }

    public B handleCookies(boolean flag) {
        ((HttpServer)((Object)this.endpoint)).setHandleCookies(flag);
        return this.self;
    }

    public B defaultStatus(HttpStatus status) {
        ((HttpServer)((Object)this.endpoint)).setDefaultStatusCode(status.value());
        return this.self;
    }

    public B interceptors(List<HandlerInterceptor> interceptors) {
        this.endpoint.setInterceptors(interceptors);
        return this.self;
    }

    public B timeout(long timeout) {
        this.endpoint.setDefaultTimeout(timeout);
        return this.self;
    }
}

