/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.AbstractEndpointParser;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.http.client.HttpClient;
import com.consol.citrus.http.client.HttpEndpointConfiguration;
import com.consol.citrus.message.ErrorHandlingStrategy;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.http.HttpMethod;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class HttpClientParser
extends AbstractEndpointParser {
    protected void parseEndpointConfiguration(BeanDefinitionBuilder endpointConfiguration, Element element, ParserContext parserContext) {
        super.parseEndpointConfiguration(endpointConfiguration, element, parserContext);
        if (element.hasAttribute("rest-template") && element.hasAttribute("request-factory")) {
            parserContext.getReaderContext().error("When providing a 'rest-template' property, no 'request-factory' should be set!", (Object)element);
        }
        if (!element.hasAttribute("request-url") && !element.hasAttribute("endpoint-resolver")) {
            parserContext.getReaderContext().error("One of the properties 'request-url' or 'endpoint-resolver' is required!", (Object)element);
        }
        if (element.hasAttribute("rest-template")) {
            BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("rest-template"), (String)"restTemplate");
        } else {
            BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("request-factory"), (String)"requestFactory");
        }
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("request-url"), (String)"requestUrl");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("default-accept-header"), (String)"defaultAcceptHeader");
        String requestMethod = element.getAttribute("request-method");
        if (StringUtils.hasText((String)requestMethod)) {
            endpointConfiguration.addPropertyValue("requestMethod", (Object)new TypedStringValue(requestMethod, HttpMethod.class));
        }
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("message-converter"), (String)"messageConverter");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("message-correlator"), (String)"correlator");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("endpoint-resolver"), (String)"endpointUriResolver");
        if (element.hasAttribute("charset")) {
            endpointConfiguration.addPropertyValue("charset", (Object)element.getAttribute("charset"));
        }
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("content-type"), (String)"contentType");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("polling-interval"), (String)"pollingInterval");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("handle-cookies"), (String)"handleCookies");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("error-handler"), (String)"errorHandler");
        if (element.hasAttribute("error-strategy")) {
            endpointConfiguration.addPropertyValue("errorHandlingStrategy", (Object)ErrorHandlingStrategy.fromName((String)element.getAttribute("error-strategy")));
        }
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("interceptors"), (String)"clientInterceptors");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("binary-media-types"), (String)"binaryMediaTypes");
        endpointConfiguration.addPropertyValue("headerMapper", (Object)DefaultHttpHeaderMapper.outboundMapper());
    }

    protected Class<? extends Endpoint> getEndpointClass() {
        return HttpClient.class;
    }

    protected Class<? extends EndpointConfiguration> getEndpointConfigurationClass() {
        return HttpEndpointConfiguration.class;
    }
}

