/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.servlet;

import com.consol.citrus.http.servlet.GzipHttpServletRequestWrapper;
import com.consol.citrus.http.servlet.GzipHttpServletResponseWrapper;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

public class GzipServletFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object filteredRequest = request;
        Object filteredResponse = response;
        if (this.isGzipEncoding(request.getHeader("Content-Encoding"))) {
            filteredRequest = new GzipHttpServletRequestWrapper(request);
        }
        if (this.isGzipEncoding(request.getHeader("Accept-Encoding"))) {
            filteredResponse = new GzipHttpServletResponseWrapper(response);
        }
        filterChain.doFilter((ServletRequest)filteredRequest, (ServletResponse)filteredResponse);
        if (filteredResponse instanceof GzipHttpServletResponseWrapper) {
            ((GzipHttpServletResponseWrapper)((Object)filteredResponse)).finish();
        }
    }

    private boolean isGzipEncoding(String contentEncoding) {
        return contentEncoding != null && contentEncoding.contains("gzip");
    }
}

