/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.interceptor;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class DelegatingHandlerInterceptor
implements HandlerInterceptor {
    private List<HandlerInterceptor> interceptors = new ArrayList<HandlerInterceptor>();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        for (HandlerInterceptor interceptor : this.interceptors) {
            if (interceptor.preHandle(request, response, handler)) continue;
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        for (HandlerInterceptor interceptor : this.interceptors) {
            interceptor.postHandle(request, response, handler, modelAndView);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        for (HandlerInterceptor interceptor : this.interceptors) {
            interceptor.afterCompletion(request, response, handler, ex);
        }
    }

    public List<HandlerInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<HandlerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

