/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.interceptor;

import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.http.controller.HttpMessageController;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.RawMessage;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoggingHandlerInterceptor
implements HandlerInterceptor {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Logger LOG = LoggerFactory.getLogger(LoggingHandlerInterceptor.class);
    private MessageListeners messageListener;
    private final TestContextFactory contextFactory = TestContextFactory.newInstance();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.handleRequest(this.getRequestContent(request));
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.handleResponse(this.getResponseContent(request, response, handler));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void handleRequest(String request) {
        if (this.hasMessageListeners()) {
            LOG.debug("Received Http request");
            this.messageListener.onInboundMessage((Message)new RawMessage(request), this.contextFactory.getObject());
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Received Http request:" + NEWLINE + request);
        }
    }

    public void handleResponse(String response) {
        if (this.hasMessageListeners()) {
            LOG.debug("Sending Http response");
            this.messageListener.onOutboundMessage((Message)new RawMessage(response), this.contextFactory.getObject());
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Sending Http response:" + NEWLINE + response);
        }
    }

    public boolean hasMessageListeners() {
        return this.messageListener != null && !this.messageListener.isEmpty();
    }

    private String getRequestContent(HttpServletRequest request) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getProtocol());
        builder.append(" ");
        builder.append(request.getMethod());
        builder.append(" ");
        builder.append(request.getRequestURI());
        builder.append(NEWLINE);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement().toString();
            builder.append(headerName);
            builder.append(":");
            Enumeration headerValues = request.getHeaders(headerName);
            if (headerValues.hasMoreElements()) {
                builder.append(headerValues.nextElement());
            }
            while (headerValues.hasMoreElements()) {
                builder.append(",");
                builder.append(headerValues.nextElement());
            }
            builder.append(NEWLINE);
        }
        builder.append(NEWLINE);
        builder.append(FileUtils.readToString((InputStream)request.getInputStream()));
        return builder.toString();
    }

    private String getResponseContent(HttpServletRequest request, HttpServletResponse response, Object handler) {
        ResponseEntity<?> responseEntity;
        HandlerMethod handlerMethod;
        StringBuilder builder = new StringBuilder();
        builder.append(response);
        if (handler instanceof HandlerMethod && (handlerMethod = (HandlerMethod)handler).getBean() instanceof HttpMessageController && (responseEntity = ((HttpMessageController)handlerMethod.getBean()).getResponseCache(request)) != null) {
            builder.append(NEWLINE);
            builder.append(responseEntity.getBody());
        }
        return builder.toString();
    }

    public void setMessageListener(MessageListeners messageListener) {
        this.messageListener = messageListener;
    }
}

