/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.actions;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.actions.HttpClientActionBuilder;
import com.consol.citrus.http.actions.HttpServerActionBuilder;
import com.consol.citrus.http.client.HttpClient;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import org.springframework.util.Assert;

public class HttpActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private TestActionBuilder<?> delegate;

    public static HttpActionBuilder http() {
        return new HttpActionBuilder();
    }

    public HttpClientActionBuilder client(HttpClient httpClient) {
        HttpClientActionBuilder clientActionBuilder = new HttpClientActionBuilder((Endpoint)httpClient).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public HttpClientActionBuilder client(String httpClient) {
        HttpClientActionBuilder clientActionBuilder = new HttpClientActionBuilder(httpClient).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public HttpServerActionBuilder server(Endpoint endpoint) {
        HttpServerActionBuilder serverActionBuilder = new HttpServerActionBuilder(endpoint).withReferenceResolver(this.referenceResolver);
        this.delegate = serverActionBuilder;
        return serverActionBuilder;
    }

    public HttpServerActionBuilder server(String httpServer) {
        HttpServerActionBuilder serverActionBuilder = new HttpServerActionBuilder(httpServer).withReferenceResolver(this.referenceResolver);
        this.delegate = serverActionBuilder;
        return serverActionBuilder;
    }

    public HttpActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }
}

