/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.message;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpEntity;
import org.springframework.util.StringUtils;

class CookieConverter
implements Serializable {
    private static final String NAME = "Name";
    private static final String VALUE = "Value";
    private static final String SECURE = "Secure";
    private static final String COMMENT = "Comment";
    private static final String PATH = "Path";
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String VERSION = "Version";
    private static final String HTTP_ONLY = "HttpOnly";

    CookieConverter() {
    }

    Cookie[] convertCookies(HttpEntity<?> httpEntity) {
        LinkedList<Cookie> cookies = new LinkedList<Cookie>();
        List inboundCookies = httpEntity.getHeaders().get((Object)"Set-Cookie");
        if (inboundCookies != null) {
            for (String cookieString : inboundCookies) {
                Cookie cookie = this.convertCookieString(cookieString);
                cookies.add(cookie);
            }
        }
        return cookies.toArray(new Cookie[0]);
    }

    String getCookieString(Cookie cookie) {
        StringBuilder builder = new StringBuilder();
        builder.append(cookie.getName());
        builder.append("=");
        builder.append(cookie.getValue());
        if (cookie.getVersion() > 0) {
            builder.append(";Version=").append(cookie.getVersion());
        }
        if (StringUtils.hasText((String)cookie.getPath())) {
            builder.append(";Path=").append(cookie.getPath());
        }
        if (StringUtils.hasText((String)cookie.getDomain())) {
            builder.append(";Domain=").append(cookie.getDomain());
        }
        if (cookie.getMaxAge() > 0) {
            builder.append(";Max-Age=").append(cookie.getMaxAge());
        }
        if (StringUtils.hasText((String)cookie.getComment())) {
            builder.append(";Comment=").append(cookie.getComment());
        }
        if (cookie.getSecure()) {
            builder.append(";Secure");
        }
        if (cookie.isHttpOnly()) {
            builder.append(";HttpOnly");
        }
        return builder.toString();
    }

    private Cookie convertCookieString(String cookieString) {
        Cookie cookie = new Cookie(this.getCookieParam(NAME, cookieString), this.getCookieParam(VALUE, cookieString));
        if (cookieString.contains(COMMENT)) {
            cookie.setComment(this.getCookieParam(COMMENT, cookieString));
        }
        if (cookieString.contains(PATH)) {
            cookie.setPath(this.getCookieParam(PATH, cookieString));
        }
        if (cookieString.contains(DOMAIN)) {
            cookie.setDomain(this.getCookieParam(DOMAIN, cookieString));
        }
        if (cookieString.contains(MAX_AGE)) {
            cookie.setMaxAge(Integer.valueOf(this.getCookieParam(MAX_AGE, cookieString)).intValue());
        }
        if (cookieString.contains(SECURE)) {
            cookie.setSecure(Boolean.valueOf(this.getCookieParam(SECURE, cookieString)).booleanValue());
        }
        if (cookieString.contains(VERSION)) {
            cookie.setVersion(Integer.valueOf(this.getCookieParam(VERSION, cookieString)).intValue());
        }
        if (cookieString.contains(HTTP_ONLY)) {
            cookie.setHttpOnly(Boolean.valueOf(this.getCookieParam(HTTP_ONLY, cookieString)).booleanValue());
        }
        return cookie;
    }

    private String getCookieParam(String param, String cookieString) {
        if (param.equals(NAME)) {
            return cookieString.substring(0, cookieString.indexOf(61));
        }
        if (param.equals(VALUE)) {
            if (cookieString.contains(";")) {
                return cookieString.substring(cookieString.indexOf(61) + 1, cookieString.indexOf(59));
            }
            return cookieString.substring(cookieString.indexOf(61) + 1);
        }
        if (this.containsFlag(SECURE, param, cookieString) || this.containsFlag(HTTP_ONLY, param, cookieString)) {
            return String.valueOf(true);
        }
        if (cookieString.contains(param + "=")) {
            int endParam = cookieString.indexOf(59, cookieString.indexOf(param + "="));
            int beginIndex = cookieString.indexOf(param + "=") + param.length() + 1;
            if (endParam > 0) {
                return cookieString.substring(beginIndex, endParam);
            }
            return cookieString.substring(beginIndex);
        }
        throw new CitrusRuntimeException(String.format("Unable to get cookie argument '%s' from cookie String: %s", param, cookieString));
    }

    private boolean containsFlag(String flag, String param, String cookieString) {
        return flag.equals(param) && cookieString.contains(flag);
    }
}

