/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.http.message.CookieEnricher;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.builder.StaticMessageBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;

public class HttpMessageBuilder
extends StaticMessageBuilder {
    private final CookieEnricher cookieEnricher;

    public HttpMessageBuilder(HttpMessage message) {
        this(message, new CookieEnricher());
    }

    HttpMessageBuilder(HttpMessage message, CookieEnricher cookieEnricher) {
        super((Message)message);
        this.cookieEnricher = cookieEnricher;
    }

    public Message build(TestContext context, String messageType) {
        HttpMessage message = new HttpMessage(super.getMessage());
        Message constructed = super.build(context, messageType);
        message.setName(constructed.getName());
        message.setType(constructed.getType());
        message.setPayload(constructed.getPayload());
        message.setCookies(this.constructCookies(context));
        this.replaceHeaders(constructed, (Message)message);
        return message;
    }

    private void replaceHeaders(Message from, Message to) {
        Set<String> headerKeys = to.getHeaders().keySet().stream().filter(key -> !FILTERED_HEADERS.contains(key)).collect(Collectors.toSet());
        headerKeys.forEach(to.getHeaders()::remove);
        from.getHeaders().entrySet().stream().filter(entry -> !FILTERED_HEADERS.contains(entry.getKey())).forEach(entry -> to.getHeaders().put((String)entry.getKey(), entry.getValue()));
    }

    private Cookie[] constructCookies(TestContext context) {
        List<Cookie> cookies = this.cookieEnricher.enrich(this.getMessage().getCookies(), context);
        return cookies.toArray(new Cookie[0]);
    }

    public HttpMessage getMessage() {
        return (HttpMessage)super.getMessage();
    }
}

