/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.servlet;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class CachingHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static Logger log = LoggerFactory.getLogger(CachingHttpServletRequestWrapper.class);
    private byte[] body;

    public CachingHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> params = new HashMap<String, String[]>(super.getParameterMap());
        MediaType contentType = Optional.ofNullable(this.getContentType()).map(mediaType -> {
            try {
                return MediaType.valueOf((String)mediaType);
            }
            catch (InvalidMediaTypeException e) {
                log.warn(String.format("Failed to parse content type '%s' - using default media type '%s'", this.getContentType(), "*/*"), (Throwable)e);
                return MediaType.ALL;
            }
        }).orElse(MediaType.ALL);
        Charset charset = Optional.ofNullable(contentType.getCharset()).orElse(Charset.forName(CitrusSettings.CITRUS_FILE_ENCODING));
        if (RequestMethod.POST.name().equals(this.getMethod()) || RequestMethod.PUT.name().equals(this.getMethod())) {
            if (new MediaType(contentType.getType(), contentType.getSubtype()).equals((Object)MediaType.APPLICATION_FORM_URLENCODED)) {
                try {
                    this.fillParams(params, new String(FileCopyUtils.copyToByteArray((InputStream)this.getInputStream()), charset), charset);
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to read request body", (Throwable)e);
                }
            }
        } else {
            this.fillParams(params, this.getQueryString(), charset);
        }
        return params;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.body == null) {
            this.body = super.getInputStream() != null ? FileCopyUtils.copyToByteArray((InputStream)super.getInputStream()) : new byte[0];
        }
        return new RequestCachingInputStream();
    }

    private void fillParams(Map<String, String[]> params, String queryString, Charset charset) {
        if (StringUtils.hasText((String)queryString)) {
            StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
            while (tokenizer.hasMoreTokens()) {
                String[] nameValuePair = tokenizer.nextToken().split("=");
                String paramName = nameValuePair[0];
                if (params.containsKey(paramName)) continue;
                String paramValue = nameValuePair.length > 1 ? nameValuePair[1] : "";
                try {
                    params.put(URLDecoder.decode(paramName, charset.name()), new String[]{URLDecoder.decode(paramValue, charset.name())});
                }
                catch (UnsupportedEncodingException e) {
                    throw new CitrusRuntimeException(String.format("Failed to decode query param value '%s=%s'", paramName, paramValue), (Throwable)e);
                }
            }
        }
    }

    private final class RequestCachingInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream is;

        private RequestCachingInputStream() {
            this.is = new ByteArrayInputStream(CachingHttpServletRequestWrapper.this.body);
        }

        public boolean isFinished() {
            return this.is.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new CitrusRuntimeException("Unsupported operation");
        }

        public int read() {
            return this.is.read();
        }
    }
}

