/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.client;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.endpoint.PollableEndpointConfiguration;
import com.consol.citrus.exceptions.MessageTimeoutException;
import com.consol.citrus.http.client.HttpEndpointConfiguration;
import com.consol.citrus.http.client.HttpErrorPropagatingException;
import com.consol.citrus.http.interceptor.LoggingClientInterceptor;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.correlation.CorrelationManager;
import com.consol.citrus.message.correlation.PollingCorrelationManager;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.messaging.ReplyConsumer;
import com.consol.citrus.messaging.SelectiveConsumer;
import java.net.URI;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class HttpClient
extends AbstractEndpoint
implements Producer,
ReplyConsumer {
    private static Logger log = LoggerFactory.getLogger(HttpClient.class);
    private CorrelationManager<Message> correlationManager;

    public HttpClient() {
        this(new HttpEndpointConfiguration());
    }

    public HttpClient(HttpEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply message did not arrive yet");
    }

    public HttpEndpointConfiguration getEndpointConfiguration() {
        return (HttpEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void send(Message message, TestContext context) {
        this.getEndpointConfiguration().getClientInterceptors().stream().filter(LoggingClientInterceptor.class::isInstance).map(LoggingClientInterceptor.class::cast).filter(interceptor -> !interceptor.hasMessageListeners()).forEach(interceptor -> interceptor.setMessageListener(context.getMessageListeners()));
        HttpMessage httpMessage = message instanceof HttpMessage ? (HttpMessage)message : new HttpMessage(message);
        String correlationKeyName = this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.getEndpointConfiguration().getCorrelator().getCorrelationKey((Message)httpMessage);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        String endpointUri = this.getEndpointUri(httpMessage);
        context.setVariable("citrus_message_replyTo_" + correlationKeyName, (Object)endpointUri);
        log.info("Sending HTTP message to: '" + endpointUri + "'");
        if (log.isDebugEnabled()) {
            log.debug("Message to send:\n" + (String)httpMessage.getPayload(String.class));
        }
        HttpMethod method = this.getEndpointConfiguration().getRequestMethod();
        if (httpMessage.getRequestMethod() != null) {
            method = httpMessage.getRequestMethod();
        }
        HttpEntity<?> requestEntity = this.getEndpointConfiguration().getMessageConverter().convertOutbound((Message)httpMessage, this.getEndpointConfiguration(), context);
        try {
            MediaType accept = Optional.ofNullable(httpMessage.getAccept()).map(mediaType -> mediaType.split(",")).map(mediaType -> {
                try {
                    return MediaType.valueOf((String)mediaType[0]);
                }
                catch (InvalidMediaTypeException e) {
                    log.warn(String.format("Failed to parse accept media type '%s' - using default media type '%s'", mediaType[0], "*/*"), (Throwable)e);
                    return MediaType.ALL;
                }
            }).orElse(MediaType.ALL);
            ResponseEntity response = this.getEndpointConfiguration().getBinaryMediaTypes().stream().anyMatch(mediaType -> mediaType.includes(accept)) ? this.getEndpointConfiguration().getRestTemplate().exchange(URI.create(endpointUri), method, requestEntity, byte[].class) : this.getEndpointConfiguration().getRestTemplate().exchange(URI.create(endpointUri), method, requestEntity, String.class);
            log.info("HTTP message was sent to endpoint: '" + endpointUri + "'");
            this.correlationManager.store(correlationKey, (Object)this.getEndpointConfiguration().getMessageConverter().convertInbound((HttpEntity<?>)response, this.getEndpointConfiguration(), context));
        }
        catch (HttpErrorPropagatingException e) {
            log.info("Caught HTTP rest client exception: " + e.getMessage());
            log.info("Propagating HTTP rest client exception according to error handling strategy");
            HttpMessage responseMessage = this.getEndpointConfiguration().getMessageConverter().convertInbound((HttpEntity<?>)new ResponseEntity((Object)e.getResponseBodyAsString(), (MultiValueMap)e.getResponseHeaders(), e.getStatusCode()), this.getEndpointConfiguration(), context);
            this.correlationManager.store(correlationKey, (Object)responseMessage);
        }
    }

    public Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    public Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.getEndpointConfiguration().getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message = (Message)this.correlationManager.find(selector, timeout);
        String endpointUri = context.getVariables().containsKey("citrus_message_replyTo_" + selector) ? context.getVariable("citrus_message_replyTo_" + selector) : this.getName();
        if (message == null) {
            throw new MessageTimeoutException(timeout, endpointUri);
        }
        return message;
    }

    private String getEndpointUri(HttpMessage httpMessage) {
        if (this.getEndpointConfiguration().getEndpointUriResolver() != null) {
            return this.getEndpointConfiguration().getEndpointUriResolver().resolveEndpointUri((Message)httpMessage, this.getEndpointConfiguration().getRequestUrl());
        }
        return this.getEndpointConfiguration().getRequestUrl();
    }

    public Producer createProducer() {
        return this;
    }

    public SelectiveConsumer createConsumer() {
        return this;
    }

    public void setCorrelationManager(CorrelationManager<Message> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

