/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.config.xml.SendMessageActionParser;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageBuilder;
import com.consol.citrus.validation.builder.DefaultMessageBuilder;
import java.util.List;
import javax.servlet.http.Cookie;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpSendResponseActionParser
extends SendMessageActionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Element body;
        Element headers;
        BeanDefinitionBuilder builder = this.parseComponent(element, parserContext);
        builder.addPropertyValue("name", (Object)("http:" + element.getLocalName()));
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)builder);
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)builder, (String)element.getAttribute("actor"), (String)"actor");
        HttpMessage httpMessage = new HttpMessage();
        if (element.hasAttribute("server")) {
            builder.addPropertyReference("endpoint", element.getAttribute("server"));
        }
        if ((headers = DomUtils.getChildElementByTagName((Element)element, (String)"headers")) != null) {
            String version;
            String reasonPhrase;
            List headerElements = DomUtils.getChildElementsByTagName((Element)headers, (String)"header");
            for (Object headerElement : headerElements) {
                Element header = (Element)headerElement;
                httpMessage.setHeader(header.getAttribute("name"), header.getAttribute("value"));
            }
            String statusCode = headers.getAttribute("status");
            if (StringUtils.hasText((String)statusCode)) {
                httpMessage.setHeader("citrus_http_status_code", statusCode);
            }
            if (StringUtils.hasText((String)(reasonPhrase = headers.getAttribute("reason-phrase")))) {
                httpMessage.reasonPhrase(reasonPhrase);
            }
            if (StringUtils.hasText((String)(version = headers.getAttribute("version")))) {
                httpMessage.version(version);
            }
            List cookieElements = DomUtils.getChildElementsByTagName((Element)headers, (String)"cookie");
            for (Object item : cookieElements) {
                Element cookieElement = (Element)item;
                Cookie cookie = new Cookie(cookieElement.getAttribute("name"), cookieElement.getAttribute("value"));
                if (cookieElement.hasAttribute("comment")) {
                    cookie.setComment(cookieElement.getAttribute("comment"));
                }
                if (cookieElement.hasAttribute("path")) {
                    cookie.setPath(cookieElement.getAttribute("path"));
                }
                if (cookieElement.hasAttribute("domain")) {
                    cookie.setDomain(cookieElement.getAttribute("domain"));
                }
                if (cookieElement.hasAttribute("max-age")) {
                    cookie.setMaxAge(Integer.valueOf(cookieElement.getAttribute("max-age")).intValue());
                }
                if (cookieElement.hasAttribute("secure")) {
                    cookie.setSecure(Boolean.valueOf(cookieElement.getAttribute("secure")).booleanValue());
                }
                if (cookieElement.hasAttribute("version")) {
                    cookie.setVersion(Integer.valueOf(cookieElement.getAttribute("version")).intValue());
                }
                httpMessage.cookie(cookie);
            }
        }
        if ((body = DomUtils.getChildElementByTagName((Element)element, (String)"body")) != null) {
            String dataDictionary;
            String messageType = body.getAttribute("type");
            if (StringUtils.hasText((String)messageType)) {
                builder.addPropertyValue("messageType", (Object)messageType);
            }
            if (StringUtils.hasText((String)(dataDictionary = body.getAttribute("data-dictionary")))) {
                builder.addPropertyReference("dataDictionary", dataDictionary);
            }
        }
        HttpMessageBuilder httpMessageBuilder = new HttpMessageBuilder(httpMessage);
        DefaultMessageBuilder messageContentBuilder = this.constructMessageBuilder(body, builder);
        httpMessageBuilder.setName(messageContentBuilder.getName());
        httpMessageBuilder.setPayloadBuilder(messageContentBuilder.getPayloadBuilder());
        messageContentBuilder.getHeaderBuilders().forEach(arg_0 -> ((HttpMessageBuilder)httpMessageBuilder).addHeaderBuilder(arg_0));
        builder.addPropertyValue("messageBuilder", (Object)httpMessageBuilder);
        return builder.getBeanDefinition();
    }
}

