/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.client;

import com.consol.citrus.common.InitializingPhase;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.Assert;

public class BasicAuthClientHttpRequestFactory
implements FactoryBean<HttpComponentsClientHttpRequestFactory>,
InitializingPhase {
    private Map<String, Object> params;
    private HttpClient httpClient;
    private Credentials credentials;
    private AuthScope authScope = new AuthScope("localhost", 8080, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
    private static Logger log = LoggerFactory.getLogger(BasicAuthClientHttpRequestFactory.class);

    public HttpComponentsClientHttpRequestFactory getObject() throws Exception {
        Assert.notNull((Object)this.credentials, (String)"User credentials not set properly!");
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient){

            protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(new HttpHost(BasicAuthClientHttpRequestFactory.this.authScope.getHost(), BasicAuthClientHttpRequestFactory.this.authScope.getPort(), "http"), (AuthScheme)basicAuth);
                authCache.put(new HttpHost(BasicAuthClientHttpRequestFactory.this.authScope.getHost(), BasicAuthClientHttpRequestFactory.this.authScope.getPort(), "https"), (AuthScheme)basicAuth);
                BasicHttpContext localcontext = new BasicHttpContext();
                localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
                return localcontext;
            }
        };
        if (this.httpClient instanceof AbstractHttpClient) {
            ((AbstractHttpClient)this.httpClient).getCredentialsProvider().setCredentials(this.authScope, this.credentials);
        } else {
            log.warn("Unable to set username password credentials for basic authentication, because nested HttpClient implementation does not support a credentials provider!");
        }
        return requestFactory;
    }

    public Class<?> getObjectType() {
        return HttpComponentsClientHttpRequestFactory.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void initialize() {
        if (this.httpClient == null) {
            this.httpClient = new DefaultHttpClient();
        }
        if (this.params != null) {
            for (Map.Entry<String, Object> param : this.params.entrySet()) {
                log.debug("Setting custom Http param on client: '" + param.getKey() + "'='" + param.getValue() + "'");
                this.httpClient.getParams().setParameter(param.getKey(), param.getValue());
            }
        }
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setAuthScope(AuthScope authScope) {
        this.authScope = authScope;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}

