/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.config.xml.MessageSelectorParser;
import com.consol.citrus.config.xml.ReceiveMessageActionParser;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageBuilder;
import com.consol.citrus.http.message.HttpQueryParamHeaderValidator;
import com.consol.citrus.validation.HeaderValidator;
import com.consol.citrus.validation.builder.DefaultMessageBuilder;
import com.consol.citrus.validation.context.HeaderValidationContext;
import java.util.List;
import javax.servlet.http.Cookie;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpReceiveRequestActionParser
extends ReceiveMessageActionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.parseComponent(element, parserContext);
        builder.addPropertyValue("name", (Object)("http:" + element.getLocalName()));
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)builder);
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)builder, (String)element.getAttribute("actor"), (String)"actor");
        String receiveTimeout = element.getAttribute("timeout");
        if (StringUtils.hasText((String)receiveTimeout)) {
            builder.addPropertyValue("receiveTimeout", (Object)Long.valueOf(receiveTimeout));
        }
        if (element.hasAttribute("server")) {
            builder.addPropertyReference("endpoint", element.getAttribute("server"));
        }
        HttpMessage httpMessage = new HttpMessage();
        Element requestElement = (Element)DomUtils.getChildElements((Element)element).get(0);
        httpMessage.method(HttpMethod.valueOf((String)requestElement.getLocalName().toUpperCase()));
        if (requestElement.hasAttribute("path")) {
            httpMessage.path(requestElement.getAttribute("path"));
        }
        if (requestElement.hasAttribute("context-path")) {
            httpMessage.contextPath(requestElement.getAttribute("context-path"));
        }
        List params = DomUtils.getChildElementsByTagName((Element)requestElement, (String)"param");
        for (Object item : params) {
            Element param = (Element)item;
            httpMessage.queryParam(param.getAttribute("name"), param.getAttribute("value"));
        }
        Element body = DomUtils.getChildElementByTagName((Element)requestElement, (String)"body");
        List validationContexts = this.parseValidationContexts(body, builder);
        validationContexts.stream().filter(context -> context instanceof HeaderValidationContext).map(context -> (HeaderValidationContext)context).forEach(context -> context.addHeaderValidator((HeaderValidator)new HttpQueryParamHeaderValidator()));
        Element headers = DomUtils.getChildElementByTagName((Element)requestElement, (String)"headers");
        if (headers != null) {
            String version;
            String accept;
            List headerElements = DomUtils.getChildElementsByTagName((Element)headers, (String)"header");
            for (Object headerElement : headerElements) {
                Element header = (Element)headerElement;
                httpMessage.setHeader(header.getAttribute("name"), header.getAttribute("value"));
            }
            String contentType = headers.getAttribute("content-type");
            if (StringUtils.hasText((String)contentType)) {
                httpMessage.contentType(contentType);
            }
            if (StringUtils.hasText((String)(accept = headers.getAttribute("accept")))) {
                httpMessage.accept(accept);
            }
            if (StringUtils.hasText((String)(version = headers.getAttribute("version")))) {
                httpMessage.version(version);
            }
            List cookieElements = DomUtils.getChildElementsByTagName((Element)headers, (String)"cookie");
            for (Object cookieElement : cookieElements) {
                Element cookie = (Element)cookieElement;
                httpMessage.cookie(new Cookie(cookie.getAttribute("name"), cookie.getAttribute("value")));
            }
            boolean ignoreCase = headers.hasAttribute("ignore-case") ? Boolean.valueOf(headers.getAttribute("ignore-case")) : true;
            validationContexts.stream().filter(context -> context instanceof HeaderValidationContext).map(context -> (HeaderValidationContext)context).forEach(context -> context.setHeaderNameIgnoreCase(ignoreCase));
        }
        MessageSelectorParser.doParse((Element)element, (BeanDefinitionBuilder)builder);
        HttpMessageBuilder httpMessageBuilder = new HttpMessageBuilder(httpMessage);
        DefaultMessageBuilder messageContentBuilder = this.constructMessageBuilder(body, builder);
        httpMessageBuilder.setName(messageContentBuilder.getName());
        httpMessageBuilder.setPayloadBuilder(messageContentBuilder.getPayloadBuilder());
        messageContentBuilder.getHeaderBuilders().forEach(arg_0 -> ((HttpMessageBuilder)httpMessageBuilder).addHeaderBuilder(arg_0));
        builder.addPropertyValue("messageBuilder", (Object)httpMessageBuilder);
        builder.addPropertyValue("validationContexts", (Object)validationContexts);
        builder.addPropertyValue("variableExtractors", (Object)this.getVariableExtractors(element));
        return builder.getBeanDefinition();
    }
}

