/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.servlet;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class GzipHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public GzipHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new GzipServletInputStream(this.getRequest());
    }

    private class GzipServletInputStream
    extends ServletInputStream {
        private final GZIPInputStream gzipStream;

        public GzipServletInputStream(ServletRequest request) throws IOException {
            this.gzipStream = new GZIPInputStream((InputStream)request.getInputStream());
        }

        public boolean isFinished() {
            try {
                return this.gzipStream.available() == 0;
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to check gzip input stream availability", (Throwable)e);
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException("Unsupported operation");
        }

        public int read() {
            try {
                return this.gzipStream.read();
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read gzip input stream", (Throwable)e);
            }
        }

        public int read(byte[] b) throws IOException {
            return this.gzipStream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.gzipStream.read(b, off, len);
        }
    }
}

