/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.xml;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.http.actions.HttpActionBuilder;
import com.consol.citrus.http.actions.HttpClientActionBuilder;
import com.consol.citrus.http.actions.HttpClientRequestActionBuilder;
import com.consol.citrus.http.actions.HttpClientResponseActionBuilder;
import com.consol.citrus.http.actions.HttpServerActionBuilder;
import com.consol.citrus.http.actions.HttpServerRequestActionBuilder;
import com.consol.citrus.http.actions.HttpServerResponseActionBuilder;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.xml.actions.Message;
import com.consol.citrus.xml.actions.Receive;
import com.consol.citrus.xml.actions.Send;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="http")
public class Http
implements TestActionBuilder<TestAction>,
ReferenceResolverAware {
    private TestActionBuilder<?> builder;
    private Receive receive;
    private Send send;
    private String description;
    private String actor;
    private ReferenceResolver referenceResolver;

    @XmlElement
    public Http setDescription(String value) {
        this.description = value;
        return this;
    }

    @XmlAttribute(name="actor")
    public Http setActor(String actor) {
        this.actor = actor;
        return this;
    }

    @XmlAttribute(name="client")
    public Http setHttpClient(String httpClient) {
        this.builder = new HttpActionBuilder().client(httpClient);
        return this;
    }

    @XmlAttribute(name="server")
    public Http setHttpServer(String httpServer) {
        this.builder = new HttpActionBuilder().server(httpServer);
        return this;
    }

    @XmlElement(name="send-request")
    public Http setSendRequest(ClientRequest request) {
        HttpClientRequestActionBuilder requestBuilder;
        HttpRequest requestMessage;
        if (request.getGet() != null) {
            requestMessage = request.getGet();
            requestBuilder = this.asClientBuilder().send().get(requestMessage.path);
        } else if (request.getPost() != null) {
            requestMessage = request.getPost();
            requestBuilder = this.asClientBuilder().send().post(requestMessage.path);
        } else if (request.getPut() != null) {
            requestMessage = request.getPut();
            requestBuilder = this.asClientBuilder().send().put(requestMessage.path);
        } else if (request.getDelete() != null) {
            requestMessage = request.getDelete();
            requestBuilder = this.asClientBuilder().send().delete(requestMessage.path);
        } else if (request.getHead() != null) {
            requestMessage = request.getHead();
            requestBuilder = this.asClientBuilder().send().head(requestMessage.path);
        } else if (request.getOptions() != null) {
            requestMessage = request.getOptions();
            requestBuilder = this.asClientBuilder().send().options(requestMessage.path);
        } else if (request.getPatch() != null) {
            requestMessage = request.getPatch();
            requestBuilder = this.asClientBuilder().send().patch(requestMessage.path);
        } else if (request.getTrace() != null) {
            requestMessage = request.getTrace();
            requestBuilder = this.asClientBuilder().send().trace(requestMessage.path);
        } else {
            throw new CitrusRuntimeException("Failed to construct proper Http client request action - missing proper Http method (GET, POST, PUT, DELETE, OPTIONS, HEAD, PATCH, TRACE)");
        }
        requestBuilder.name("http:send-request");
        requestBuilder.description(this.description);
        this.send = new Send(requestBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (request.fork != null) {
            this.send.setFork(request.fork);
        }
        this.send.setMessage((Message)requestMessage);
        if (request.extract != null) {
            this.send.setExtract(request.extract);
        }
        if (request.uri != null) {
            ((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).header("citrus_endpoint_uri", request.uri);
        }
        if (requestMessage.contentType != null) {
            ((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).contentType(requestMessage.contentType);
        }
        if (requestMessage.accept != null) {
            ((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).accept(requestMessage.accept);
        }
        if (requestMessage.version != null) {
            ((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).version(requestMessage.version);
        }
        for (HttpRequest.QueryParameter param : requestMessage.getParameters()) {
            if (param.value != null) {
                requestBuilder.queryParam(param.name, param.value);
                continue;
            }
            requestBuilder.queryParam(param.name);
        }
        this.builder = requestBuilder;
        return this;
    }

    @XmlElement(name="receive-response")
    public Http setReceiveResponse(ClientResponse response) {
        HttpClientResponseActionBuilder responseBuilder = (HttpClientResponseActionBuilder)this.asClientBuilder().receive().response().name("http:receive-response");
        responseBuilder.description(this.description);
        this.receive = new Receive(responseBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        if (response.getResponse() != null) {
            ((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).header("citrus_http_status_code", response.getResponse().status);
            if (response.getResponse().reasonPhrase != null) {
                ((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).reasonPhrase(response.getResponse().reasonPhrase);
            }
            if (response.getResponse().contentType != null) {
                ((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).contentType(response.getResponse().contentType);
            }
            if (response.getResponse().version != null) {
                ((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).version(response.getResponse().version);
            }
            this.receive.setMessage((Message)response.getResponse());
            if (response.timeout != null) {
                this.receive.setTimeout(response.timeout);
            }
            this.receive.setSelect(response.select);
            this.receive.setValidator(response.validator);
            this.receive.setValidators(response.validators);
            this.receive.setHeaderValidator(response.headerValidator);
            this.receive.setHeaderValidators(response.headerValidators);
            if (response.selector != null) {
                this.receive.setSelector(response.selector);
            }
            this.receive.setSelect(response.select);
            response.getValidates().forEach(this.receive.getValidates()::add);
            if (response.extract != null) {
                this.receive.setExtract(response.extract);
            }
        }
        this.builder = responseBuilder;
        return this;
    }

    @XmlElement(name="receive-request")
    public Http setReceiveRequest(ServerRequest request) {
        HttpServerRequestActionBuilder requestBuilder;
        HttpRequest requestMessage;
        if (request.getGet() != null) {
            requestMessage = request.getGet();
            requestBuilder = this.asServerBuilder().receive().get(requestMessage.path);
        } else if (request.getPost() != null) {
            requestMessage = request.getPost();
            requestBuilder = this.asServerBuilder().receive().post(requestMessage.path);
        } else if (request.getPut() != null) {
            requestMessage = request.getPut();
            requestBuilder = this.asServerBuilder().receive().put(requestMessage.path);
        } else if (request.getDelete() != null) {
            requestMessage = request.getDelete();
            requestBuilder = this.asServerBuilder().receive().delete(requestMessage.path);
        } else if (request.getHead() != null) {
            requestMessage = request.getHead();
            requestBuilder = this.asServerBuilder().receive().head(requestMessage.path);
        } else if (request.getOptions() != null) {
            requestMessage = request.getOptions();
            requestBuilder = this.asServerBuilder().receive().options(requestMessage.path);
        } else if (request.getPatch() != null) {
            requestMessage = request.getPatch();
            requestBuilder = this.asServerBuilder().receive().patch(requestMessage.path);
        } else if (request.getTrace() != null) {
            requestMessage = request.getTrace();
            requestBuilder = this.asServerBuilder().receive().trace(requestMessage.path);
        } else {
            throw new CitrusRuntimeException("Failed to construct proper Http client request action - missing proper Http method (GET, POST, PUT, DELETE, OPTIONS, HEAD, PATCH, TRACE)");
        }
        requestBuilder.name("http:receive-request");
        requestBuilder.description(this.description);
        if (requestMessage.contentType != null) {
            ((HttpServerRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).contentType(requestMessage.contentType);
        }
        if (requestMessage.accept != null) {
            ((HttpServerRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).accept(requestMessage.accept);
        }
        if (requestMessage.version != null) {
            ((HttpServerRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).version(requestMessage.version);
        }
        this.receive = new Receive(requestBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        this.receive.setMessage((Message)requestMessage);
        if (request.selector != null) {
            this.receive.setSelector(request.selector);
        }
        this.receive.setSelect(request.select);
        this.receive.setValidator(request.validator);
        this.receive.setValidators(request.validators);
        this.receive.setHeaderValidator(request.headerValidator);
        this.receive.setHeaderValidators(request.headerValidators);
        if (request.timeout != null) {
            this.receive.setTimeout(request.timeout);
        }
        request.getValidates().forEach(this.receive.getValidates()::add);
        if (request.extract != null) {
            this.receive.setExtract(request.extract);
        }
        for (HttpRequest.QueryParameter param : requestMessage.getParameters()) {
            if (param.value != null) {
                requestBuilder.queryParam(param.name, param.value);
                continue;
            }
            requestBuilder.queryParam(param.name);
        }
        this.builder = requestBuilder;
        return this;
    }

    @XmlElement(name="send-response")
    public Http setSendResponse(ServerResponse response) {
        HttpServerResponseActionBuilder responseBuilder = (HttpServerResponseActionBuilder)this.asServerBuilder().send().response().name("http:send-response");
        responseBuilder.description(this.description);
        this.send = new Send(responseBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (response.getResponse() != null) {
            this.send.setMessage((Message)response.getResponse());
            if (response.extract != null) {
                this.send.setExtract(response.extract);
            }
            ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).header("citrus_http_status_code", response.getResponse().status);
            if (response.getResponse().reasonPhrase != null) {
                ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).reasonPhrase(response.getResponse().reasonPhrase);
            }
            if (response.getResponse().contentType != null) {
                ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).contentType(response.getResponse().contentType);
            }
            if (response.getResponse().version != null) {
                ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).version(response.getResponse().version);
            }
        }
        this.builder = responseBuilder;
        return this;
    }

    public TestAction build() {
        if (this.builder == null) {
            throw new CitrusRuntimeException("Missing client or server Http action - please provide proper action details");
        }
        if (this.send != null) {
            this.send.setReferenceResolver(this.referenceResolver);
            this.send.setActor(this.actor);
            this.send.build();
        }
        if (this.receive != null) {
            this.receive.setReferenceResolver(this.referenceResolver);
            this.receive.setActor(this.actor);
            this.receive.build();
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    private HttpClientActionBuilder asClientBuilder() {
        if (this.builder instanceof HttpClientActionBuilder) {
            return (HttpClientActionBuilder)this.builder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to http client action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    private HttpServerActionBuilder asServerBuilder() {
        if (this.builder instanceof HttpServerActionBuilder) {
            return (HttpServerActionBuilder)this.builder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to http client action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"parameters"})
    public static class HttpRequest
    extends Message {
        @XmlAttribute
        protected String path;
        @XmlAttribute(name="content-type")
        protected String contentType;
        @XmlAttribute(name="accept")
        protected String accept;
        @XmlAttribute(name="version")
        protected String version;
        @XmlElement(name="param")
        protected List<QueryParameter> parameters;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getAccept() {
            return this.accept;
        }

        public void setAccept(String accept) {
            this.accept = accept;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public List<QueryParameter> getParameters() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<QueryParameter>();
            }
            return this.parameters;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="")
        public static class QueryParameter {
            @XmlAttribute(name="name", required=true)
            protected String name;
            @XmlAttribute(name="value")
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class HttpResponse
    extends Message {
        @XmlAttribute(name="status")
        protected String status = "200";
        @XmlAttribute(name="reason-phrase")
        protected String reasonPhrase;
        @XmlAttribute(name="version")
        protected String version;
        @XmlAttribute(name="content-type")
        protected String contentType;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }

        public void setReasonPhrase(String reasonPhrase) {
            this.reasonPhrase = reasonPhrase;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"selector", "response", "validates", "extract"})
    public static class ClientResponse {
        @XmlAttribute
        protected Integer timeout;
        @XmlAttribute
        protected String select;
        @XmlAttribute
        protected String validator;
        @XmlAttribute
        protected String validators;
        @XmlAttribute(name="header-validator")
        protected String headerValidator;
        @XmlAttribute(name="header-validators")
        protected String headerValidators;
        @XmlElement
        protected Receive.Selector selector;
        @XmlElement
        protected HttpResponse response;
        @XmlElement(name="validate")
        protected List<Receive.Validate> validates;
        @XmlElement
        protected Message.Extract extract;

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public Receive.Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Receive.Selector selector) {
            this.selector = selector;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        public List<Receive.Validate> getValidates() {
            if (this.validates == null) {
                this.validates = new ArrayList<Receive.Validate>();
            }
            return this.validates;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"response", "extract"})
    public static class ServerResponse {
        @XmlElement
        protected HttpResponse response;
        @XmlElement
        protected Message.Extract extract;

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"selector", "get", "post", "put", "delete", "head", "options", "patch", "trace", "validates", "extract"})
    public static class ServerRequest {
        @XmlAttribute
        protected Integer timeout;
        @XmlAttribute
        protected String select;
        @XmlAttribute
        protected String validator;
        @XmlAttribute
        protected String validators;
        @XmlAttribute(name="header-validator")
        protected String headerValidator;
        @XmlAttribute(name="header-validators")
        protected String headerValidators;
        @XmlElement(name="GET")
        protected HttpRequest get;
        @XmlElement(name="POST")
        protected HttpRequest post;
        @XmlElement(name="PUT")
        protected HttpRequest put;
        @XmlElement(name="DELETE")
        protected HttpRequest delete;
        @XmlElement(name="HEAD")
        protected HttpRequest head;
        @XmlElement(name="OPTIONS")
        protected HttpRequest options;
        @XmlElement(name="PATCH")
        protected HttpRequest patch;
        @XmlElement(name="TRACE")
        protected HttpRequest trace;
        @XmlElement
        protected Receive.Selector selector;
        @XmlElement(name="validate")
        protected List<Receive.Validate> validates;
        @XmlElement
        protected Message.Extract extract;

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public HttpRequest getGet() {
            return this.get;
        }

        public void setGet(HttpRequest get) {
            this.get = get;
        }

        public HttpRequest getPost() {
            return this.post;
        }

        public void setPost(HttpRequest post) {
            this.post = post;
        }

        public HttpRequest getPut() {
            return this.put;
        }

        public void setPut(HttpRequest put) {
            this.put = put;
        }

        public HttpRequest getDelete() {
            return this.delete;
        }

        public void setDelete(HttpRequest delete) {
            this.delete = delete;
        }

        public HttpRequest getHead() {
            return this.head;
        }

        public void setHead(HttpRequest head) {
            this.head = head;
        }

        public HttpRequest getOptions() {
            return this.options;
        }

        public void setOptions(HttpRequest options) {
            this.options = options;
        }

        public HttpRequest getPatch() {
            return this.patch;
        }

        public void setPatch(HttpRequest patch) {
            this.patch = patch;
        }

        public HttpRequest getTrace() {
            return this.trace;
        }

        public void setTrace(HttpRequest trace) {
            this.trace = trace;
        }

        public Receive.Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Receive.Selector selector) {
            this.selector = selector;
        }

        public List<Receive.Validate> getValidates() {
            if (this.validates == null) {
                this.validates = new ArrayList<Receive.Validate>();
            }
            return this.validates;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"get", "post", "put", "delete", "head", "options", "patch", "trace", "extract"})
    public static class ClientRequest {
        @XmlAttribute(name="uri")
        protected String uri;
        @XmlAttribute(name="fork")
        protected Boolean fork;
        @XmlElement(name="GET")
        protected HttpRequest get;
        @XmlElement(name="POST")
        protected HttpRequest post;
        @XmlElement(name="PUT")
        protected HttpRequest put;
        @XmlElement(name="DELETE")
        protected HttpRequest delete;
        @XmlElement(name="HEAD")
        protected HttpRequest head;
        @XmlElement(name="OPTIONS")
        protected HttpRequest options;
        @XmlElement(name="PATCH")
        protected HttpRequest patch;
        @XmlElement(name="TRACE")
        protected HttpRequest trace;
        @XmlElement
        protected Message.Extract extract;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public Boolean getFork() {
            return this.fork;
        }

        public void setFork(Boolean fork) {
            this.fork = fork;
        }

        public HttpRequest getGet() {
            return this.get;
        }

        public void setGet(HttpRequest get) {
            this.get = get;
        }

        public HttpRequest getPost() {
            return this.post;
        }

        public void setPost(HttpRequest post) {
            this.post = post;
        }

        public HttpRequest getPut() {
            return this.put;
        }

        public void setPut(HttpRequest put) {
            this.put = put;
        }

        public HttpRequest getDelete() {
            return this.delete;
        }

        public void setDelete(HttpRequest delete) {
            this.delete = delete;
        }

        public HttpRequest getHead() {
            return this.head;
        }

        public void setHead(HttpRequest head) {
            this.head = head;
        }

        public HttpRequest getOptions() {
            return this.options;
        }

        public void setOptions(HttpRequest options) {
            this.options = options;
        }

        public HttpRequest getPatch() {
            return this.patch;
        }

        public void setPatch(HttpRequest patch) {
            this.patch = patch;
        }

        public HttpRequest getTrace() {
            return this.trace;
        }

        public void setTrace(HttpRequest trace) {
            this.trace = trace;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }
}

