/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.actions;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.http.actions.HttpClientRequestActionBuilder;
import com.consol.citrus.http.actions.HttpClientResponseActionBuilder;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HttpClientActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private Endpoint httpClient;
    private String httpClientUri;
    private TestActionBuilder<?> delegate;

    public HttpClientActionBuilder(Endpoint httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClientActionBuilder(String httpClientUri) {
        this.httpClientUri = httpClientUri;
    }

    public HttpClientSendActionBuilder send() {
        return new HttpClientSendActionBuilder();
    }

    public HttpClientReceiveActionBuilder receive() {
        return new HttpClientReceiveActionBuilder();
    }

    private HttpClientRequestActionBuilder request(HttpMethod method, String path) {
        HttpClientRequestActionBuilder builder = new HttpClientRequestActionBuilder();
        if (this.httpClient != null) {
            builder.endpoint(this.httpClient);
        } else {
            builder.endpoint(this.httpClientUri);
        }
        builder.withReferenceResolver(this.referenceResolver);
        builder.method(method);
        if (StringUtils.hasText((String)path)) {
            builder.path(path);
        }
        this.delegate = builder;
        return builder;
    }

    public HttpClientActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }

    public class HttpClientSendActionBuilder {
        public HttpClientRequestActionBuilder get() {
            return HttpClientActionBuilder.this.request(HttpMethod.GET, null);
        }

        public HttpClientRequestActionBuilder get(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.GET, path);
        }

        public HttpClientRequestActionBuilder post() {
            return HttpClientActionBuilder.this.request(HttpMethod.POST, null);
        }

        public HttpClientRequestActionBuilder post(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.POST, path);
        }

        public HttpClientRequestActionBuilder put() {
            return HttpClientActionBuilder.this.request(HttpMethod.PUT, null);
        }

        public HttpClientRequestActionBuilder put(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.PUT, path);
        }

        public HttpClientRequestActionBuilder delete() {
            return HttpClientActionBuilder.this.request(HttpMethod.DELETE, null);
        }

        public HttpClientRequestActionBuilder delete(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.DELETE, path);
        }

        public HttpClientRequestActionBuilder head() {
            return HttpClientActionBuilder.this.request(HttpMethod.HEAD, null);
        }

        public HttpClientRequestActionBuilder head(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.HEAD, path);
        }

        public HttpClientRequestActionBuilder options() {
            return HttpClientActionBuilder.this.request(HttpMethod.OPTIONS, null);
        }

        public HttpClientRequestActionBuilder options(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.OPTIONS, path);
        }

        public HttpClientRequestActionBuilder trace() {
            return HttpClientActionBuilder.this.request(HttpMethod.TRACE, null);
        }

        public HttpClientRequestActionBuilder trace(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.TRACE, path);
        }

        public HttpClientRequestActionBuilder patch() {
            return HttpClientActionBuilder.this.request(HttpMethod.PATCH, null);
        }

        public HttpClientRequestActionBuilder patch(String path) {
            return HttpClientActionBuilder.this.request(HttpMethod.PATCH, path);
        }
    }

    public class HttpClientReceiveActionBuilder {
        public HttpClientResponseActionBuilder response() {
            HttpClientResponseActionBuilder builder = new HttpClientResponseActionBuilder();
            if (HttpClientActionBuilder.this.httpClient != null) {
                builder.endpoint(HttpClientActionBuilder.this.httpClient);
            } else {
                builder.endpoint(HttpClientActionBuilder.this.httpClientUri);
            }
            builder.withReferenceResolver(HttpClientActionBuilder.this.referenceResolver);
            HttpClientActionBuilder.this.delegate = builder;
            return builder;
        }

        public HttpClientResponseActionBuilder response(HttpStatus status) {
            HttpClientResponseActionBuilder builder = new HttpClientResponseActionBuilder();
            if (HttpClientActionBuilder.this.httpClient != null) {
                builder.endpoint(HttpClientActionBuilder.this.httpClient);
            } else {
                builder.endpoint(HttpClientActionBuilder.this.httpClientUri);
            }
            builder.withReferenceResolver(HttpClientActionBuilder.this.referenceResolver);
            ((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)builder.message()).status(status);
            HttpClientActionBuilder.this.delegate = builder;
            return builder;
        }
    }
}

